<?php

namespace CorporateTrainingBundle\Biz\NotificationCenter;

use AppBundle\Extension\Extension;
use CorporateTrainingBundle\Biz\NotificationCenter\ResourceNotification\Classroom;
use CorporateTrainingBundle\Biz\NotificationCenter\ResourceNotification\Course;
use CorporateTrainingBundle\Biz\NotificationCenter\ResourceNotification\OfflineActivity;
use CorporateTrainingBundle\Biz\NotificationCenter\ResourceNotification\OfflineCourse;
use CorporateTrainingBundle\Biz\NotificationCenter\ResourceNotification\OfflineExam;
use CorporateTrainingBundle\Biz\NotificationCenter\ResourceNotification\PostCourse;
use CorporateTrainingBundle\Biz\NotificationCenter\ResourceNotification\ProjectPlan;
use CorporateTrainingBundle\Biz\NotificationCenter\Strategy\Group\Impl\ClassroomGroup;
use CorporateTrainingBundle\Biz\NotificationCenter\Strategy\Group\Impl\CourseGroup;
use CorporateTrainingBundle\Biz\NotificationCenter\Strategy\Group\Impl\OfflineActivityGroup;
use CorporateTrainingBundle\Biz\NotificationCenter\Strategy\Group\Impl\PostGroup;
use CorporateTrainingBundle\Biz\NotificationCenter\Strategy\Group\Impl\ProjectPlanGroup;
use CorporateTrainingBundle\Biz\NotificationCenter\Strategy\Group\Impl\UserGroup;
use CorporateTrainingBundle\Biz\NotificationCenter\ResourceNotification\ResourceQuestionnaire;
use CorporateTrainingBundle\Biz\NotificationCenter\Strategy\Notification\Impl\SmsNotificationStrategy;
use CorporateTrainingBundle\Biz\NotificationCenter\Strategy\Notification\Impl\DefaultNotificationStrategy;
use CorporateTrainingBundle\Biz\NotificationCenter\Strategy\Notification\Impl\DingTalkNotificationStrategy;
use CorporateTrainingBundle\Biz\NotificationCenter\Strategy\Notification\Impl\EmailNotificationStrategy;
use Pimple\Container;
use Pimple\ServiceProviderInterface;

class NotificationServiceProvider extends Extension implements ServiceProviderInterface
{
    public function register(Container $biz)
    {
        $biz['notification_default'] = function ($biz) {
            return new DefaultNotificationStrategy($biz);
        };

        $biz['notification_email'] = function ($biz) {
            return new EmailNotificationStrategy($biz);
        };

        $biz['notification_sms'] = function ($biz) {
            return new SmsNotificationStrategy($biz);
        };

        /*
        * 1.用户报名通知 您报名的 ${content} 已成功加入，请登录${sitename} 的“学习”中查看
        * 2.用户报名审核失败通知 您报名的${content} 未通过审核，原因：${reason}，请登录${sitename}进行查看
        * 3.用户报名补位通知 您报名的${content} 由于人数已满，你已进入补位中，当前排名第${queueNum}位
        * 4.线下课程上课通知 您参加的《${title}》上课地点：${place}，将于${startTime}开始，请准时出席
        * 5.问卷推送通知 您有一份问卷需要完成，请登录${sitename}的“学习”中进行作答
        * 6.线上考试推送通知 您参加的考试《${title}》将于${startTime}开始，请准时登录${sitename}的“学习”中参加考试
        * 7.线下考试推送通知 您参加的考试《${title}》将于${startTime}开始，考试地点：${place}，请提前准备，准时参加
        * 8.考试结果通知 您参加的考试《${title}》已完成批阅，成绩：${score}。请登录${sitename}的“个人中心”-“学习档案”中查看
        * 9.线下课程开班通知 您订阅的线下课程：《${title}》发布了新的开班！上课时间：${startTime} 上课地点：${place}，请登录${sitename}进行查看
        */
        $biz['notification_sms_template_list'] = function () {
            return [
                'offline_class_publish' => 2110, //线下课程开班通知 setting:sms_offline_class_publish
                'online_exam_result' => 2109, //考试结果通知 setting:sms_online_exam_result
                'offline_exam_start' => 2108, //线下考试推送通知 setting:sms_offline_exam_start
                'online_exam_start' => 2107, //线上考试 setting:sms_online_exam_start
                'survey_push' => 2106, //问卷推送通知 setting: sms_survey_push
                'offline_course_start' => 2105, //线下课程上课通知 setting:sms_offline_course_start
                'resource_enroll_queue' => 2104, //用户报名补位通知 setting:sms_resource_enroll
                'resource_enroll_failed' => 2103, //用户报名审核失败 setting:sms_resource_enroll
                'resource_enroll_success' => 2102, //用户报名通知 setting:sms_resource_enroll
            ];
        };

        $biz['notification_dingtalk'] = function ($biz) {
            return new DingTalkNotificationStrategy($biz);
        };

        $biz['notification_user_group_offline_activity'] = function ($biz) {
            return new OfflineActivityGroup($biz);
        };

        $biz['notification_user_group_project_plan'] = function ($biz) {
            return new ProjectPlanGroup($biz);
        };

        $biz['notification_user_group_user'] = function ($biz) {
            return new UserGroup($biz);
        };

        $biz['notification_user_group_post'] = function ($biz) {
            return new PostGroup($biz);
        };

        $biz['notification_user_group_course'] = function ($biz) {
            return new CourseGroup($biz);
        };

        $biz['notification_user_group_classroom'] = function ($biz) {
            return new ClassroomGroup($biz);
        };

        $biz['resource_notification.post_course'] = function ($biz) {
            return new PostCourse($biz);
        };

        $biz['resource_notification.project_plan'] = function ($biz) {
            return new ProjectPlan($biz);
        };

        $biz['resource_notification.offline_activity'] = function ($biz) {
            return new OfflineActivity($biz);
        };

        $biz['resource_notification.offline_exam'] = function ($biz) {
            return new OfflineExam($biz);
        };

        $biz['resource_notification.course'] = function ($biz) {
            return new Course($biz);
        };

        $biz['resource_notification.classroom'] = function ($biz) {
            return new Classroom($biz);
        };

        $biz['resource_notification.offline_course'] = function ($biz) {
            return new OfflineCourse($biz);
        };

        $biz['resource_notification.resource_questionnaire'] = function ($biz) {
            return new ResourceQuestionnaire($biz);
        };
    }
}
