<?php

namespace CorporateTrainingBundle\Biz\NotificationCenter\QueueJob;

use Biz\System\Service\LogService;
use Topxia\Service\Common\ServiceKernel;
use Codeages\Biz\Framework\Queue\AbstractJob;
use Codeages\Biz\Framework\Queue\Service\QueueService;

class SmsNotificationJob extends AbstractJob
{
    public function execute()
    {
        $context = $this->getBody();
        $to = $context['to'];
        $content = $context['content'];

        $group = $this->biz->offsetGet('notification_user_group_'.$to['type']);
        $mobileGroup = $group->findGroupMobiles($to);
        $templateList = $this->biz->offsetGet('notification_sms_template_list');
        if (empty($mobileGroup['mobiles']) || empty($content['template']) || empty($templateList[$content['template']])) {
            return true;
        }
        try {
            $smsOptions = [
                'to' => $mobileGroup['mobiles'],
                'template' => $content['template'],
                'params' => $content['params'],
                'type' => 'notification',
            ];

            $smsParams = [
                'mobiles' => $mobileGroup['mobiles'],
                'templateId' => $templateList[$content['template']],
                'templateParams' => $content['params'],
            ];

            $this->getSDKSmsService()->sendToMany($smsParams);

            if ($mobileGroup['params']['startNum'] < $mobileGroup['num']) {
                $emailNotificationJob = new self(
                    [
                        'to' => $mobileGroup['params'],
                        'content' => $content,
                    ]
                );
                $this->getQueueService()->pushJob($emailNotificationJob, 'database');
            }
        } catch (\Exception $e) {
            $this->getLogService()->error('mail_notification', 'mail_notification', '短信通知发送失败:'.$e->getMessage().serialize($smsOptions));
        }
    }

    /**
     * @return LogService
     */
    protected function getLogService()
    {
        return $this->biz->service('System:LogService');
    }

    /**
     * @return QueueService
     */
    protected function getQueueService()
    {
        return $this->biz->service('Queue:QueueService');
    }

    protected function getSDKSmsService()
    {
        return ServiceKernel::instance()->getBiz()['qiQiuYunSdk.sms'];
    }
}
