<?php

namespace CorporateTrainingBundle\Biz\NotificationCenter\ResourceNotification;

use AppBundle\Common\SettingToolkit;
use Biz\Sms\Service\SmsService;
use Biz\System\Service\SettingService;
use Biz\User\Service\NotificationService;
use Biz\User\Service\UserService;
use Codeages\Biz\Framework\Context\Biz;
use Codeages\Biz\Framework\Queue\Service\QueueService;
use Codeages\Biz\Framework\Scheduler\Service\SchedulerService;
use CorporateTrainingBundle\Biz\OfflineExam\Service\OfflineExamService;
use CorporateTrainingBundle\Biz\PostCourse\Service\PostCourseService;
use CorporateTrainingBundle\Biz\ProjectPlan\Service\ProjectPlanService;
use OfflineCourseProPlugin\Biz\OfflineClass\Service\OfflineClassService;
use CorporateTrainingBundle\Biz\Enroll\Service\EnrollRecordService;
use OfflineCourseProPlugin\Biz\OfflineCourseTemplate\Service\OfflineCourseTemplateService;

abstract class BaseResourceNotification
{
    protected $mailSetting = [];
    protected $dingtalkSetting = [];
    /**
     * @var Biz
     */
    protected $biz = null;

    public function __construct($biz)
    {
        $this->biz = $biz;
        $this->mailSetting = $this->getSettingService()->get('mail_notification', []);
        $this->dingtalkSetting = $this->getSettingService()->get('dingtalk_notification', []);
    }

    protected function checkDingTalkSetting($type)
    {
        return !empty($this->dingtalkSetting[$type]);
    }

    protected function checkEmailSetting($type)
    {
        return !empty($this->mailSetting[$type]);
    }

    protected function checkSmsSetting($type)
    {
        return $this->getSmsService()->isOpen($type);
    }

    protected function generateUrl($name, $parameters, $referenceType)
    {
        global $kernel;

        return $kernel->getContainer()->get('router')->generate($name, $parameters, $referenceType);
    }

    protected function sendEnrollSuccessSmsNotification($userIds, $content)
    {
        if (!$this->checkSmsSetting('sms_resource_enroll')) {
            return true;
        }

        $to = [
            'type' => 'user',
            'userIds' => $userIds,
            'startNum' => 0,
            'perPageNum' => 20,
        ];
        $content = [
            'template' => 'resource_enroll_success',
            'params' => [
                'content' => $content,
                'sitename' => SettingToolkit::getSetting('site.name', 'EDUSOHO'),
            ],
        ];
        $this->biz->offsetGet('notification_sms')->send($to, $content);
    }

    protected function sendEnrollRejectSmsNotification($userIds, $content, $reason)
    {
        if (!$this->checkSmsSetting('sms_resource_enroll')) {
            return true;
        }

        $to = [
            'type' => 'user',
            'userIds' => $userIds,
            'startNum' => 0,
            'perPageNum' => 20,
        ];
        $content = [
            'template' => 'resource_enroll_failed',
            'params' => [
                'content' => $content,
                'reason' => $reason,
                'sitename' => SettingToolkit::getSetting('site.name', 'EDUSOHO'),
            ],
        ];
        $this->biz->offsetGet('notification_sms')->send($to, $content);
    }

    protected function sendEnrollQueueSmsNotification($userId, $content, $queueNum)
    {
        if (!$this->checkSmsSetting('sms_resource_enroll')) {
            return true;
        }

        $to = [
            'type' => 'user',
            'userIds' => [$userId],
            'startNum' => 0,
            'perPageNum' => 20,
        ];
        $content = [
            'template' => 'resource_enroll_queue',
            'params' => [
                'content' => $content,
                'queueNum' => $queueNum,
            ],
        ];
        $this->biz->offsetGet('notification_sms')->send($to, $content);
    }

    /**
     * @return QueueService
     */
    protected function getQueueService()
    {
        return $this->biz->service('Queue:QueueService');
    }

    /**
     * @return PostCourseService
     */
    protected function getPostCourseService()
    {
        return $this->biz->service('CorporateTrainingBundle:PostCourse:PostCourseService');
    }

    /**
     * @return UserService
     */
    protected function getUserService()
    {
        return $this->biz->service('CorporateTrainingBundle:User:UserService');
    }

    /**
     * @return SettingService
     */
    protected function getSettingService()
    {
        return $this->biz->service('System:SettingService');
    }

    /**
     * @return SchedulerService
     */
    protected function getSchedulerService()
    {
        return $this->biz->service('Scheduler:SchedulerService');
    }

    /**
     * @return ProjectPlanService
     */
    protected function getProjectPlanService()
    {
        return $this->biz->service('CorporateTrainingBundle:ProjectPlan:ProjectPlanService');
    }

    /**
     * @return OfflineClassService
     */
    protected function getOfflineClassService()
    {
        return $this->biz->service('OfflineCourseProPlugin:OfflineClass:OfflineClassService');
    }

    /**
     * @return EnrollRecordService
     */
    protected function getEnrollRecordService()
    {
        return $this->biz->service('CorporateTrainingBundle:Enroll:EnrollRecordService');
    }

    /**
     * @return NotificationService
     */
    protected function getNotificationService()
    {
        return $this->biz->service('User:NotificationService');
    }

    protected function getJobDao()
    {
        return $this->biz->dao('Scheduler:JobDao');
    }

    /**
     * @return OfflineExamService
     */
    protected function getOfflineExamService()
    {
        return $this->biz->service('CorporateTrainingBundle:OfflineExam:OfflineExamService');
    }

    /**
     * @return OfflineCourseTemplateService
     */
    protected function getOfflineCourseTemplateService()
    {
        return $this->biz->service('OfflineCourseProPlugin:OfflineCourseTemplate:OfflineCourseTemplateService');
    }

    /**
     * @return SmsService
     */
    protected function getSmsService()
    {
        return $this->biz->service('Sms:SmsService');
    }
}
