<?php

namespace CorporateTrainingBundle\Biz\NotificationCenter\ResourceNotification;

class Classroom extends BaseResourceNotification
{
    /**
     * 管理员直接添加
     *
     * @param $classroomId
     * @param $userIds
     * @param $dingTalkNotificationSetting
     */
    public function onAdminSelectUsers($classroomId, $userIds, $dingTalkNotificationSetting)
    {
        if ($dingTalkNotificationSetting && $this->checkDingTalkSetting('classroom_assign')) {
            $types[] = 'dingtalk';
        }
        if (empty($types) || empty($userIds)) {
            return;
        }

        list($to, $content) = $this->buildNotificationData($classroomId, $userIds, 'classroom_assign');
        $this->biz->offsetGet('notification_default')->send($types, $to, $content);
    }

    protected function buildNotificationData($targetId, $userIds, $template)
    {
        global $kernel;
        $url = $kernel->getContainer()->get('router')->generate('classroom_introductions', ['id' => $targetId], true);
        $classroom = $this->getClassroomService()->getClassroom($targetId);
        $to = [
            'type' => 'user',
            'userIds' => $userIds,
            'startNum' => 0,
            'perPageNum' => 20,
        ];
        $content = [
            'template' => $template,
            'params' => [
                'targetId' => $classroom['id'],
                'batch' => $template.$targetId.time(),
                'classroomTitle' => $classroom['title'],
                'url' => $url,
                'imagePath' => $classroom['middlePicture'],
            ],
        ];

        return [$to, $content];
    }

    /**
     * @return \Biz\Classroom\Service\Impl\ClassroomServiceImpl
     */
    protected function getClassroomService()
    {
        return $this->biz->service('Classroom:ClassroomService');
    }
}
