<?php

namespace CorporateTrainingBundle\Biz\NotificationCenter\ResourceNotification;

use CorporateTrainingBundle\Biz\Course\Service\CourseSetService;

class Course extends BaseResourceNotification
{
    /**
     * 管理员直接添加
     *
     * @param $courseId
     * @param $userIds
     * @param $dingTalkNotificationSetting
     */
    public function onAdminSelectUsers($courseId, $userIds, $dingTalkNotificationSetting)
    {
        if ($dingTalkNotificationSetting && $this->checkDingTalkSetting('online_course_assign')) {
            $types[] = 'dingtalk';
        }
        if (empty($types) || empty($userIds)) {
            return;
        }

        list($to, $content) = $this->buildNotificationData($courseId, $userIds, 'online_course_assign');
        $this->biz->offsetGet('notification_default')->send($types, $to, $content);
    }

    protected function buildNotificationData($targetId, $userIds, $template)
    {
        global $kernel;
        $url = $kernel->getContainer()->get('router')->generate('course_show', ['id' => $targetId], true);
        $course = $this->getCourseService()->getCourse($targetId);
        $courseSet = $this->getCourseSetService()->getCourseSet($course['courseSetId']);

        $to = [
            'type' => 'user',
            'userIds' => $userIds,
            'startNum' => 0,
            'perPageNum' => 20,
        ];
        $content = [
            'template' => $template,
            'params' => [
                'targetId' => $course['id'],
                'batch' => $template.$targetId.time(),
                'courseTitle' => $courseSet['title'],
                'url' => $url,
                'imagePath' => empty($courseSet['cover']['large']) ? '' : $courseSet['cover']['large'],
            ],
        ];

        return [$to, $content];
    }

    /**
     * @return \CorporateTrainingBundle\Biz\Course\Service\Impl\CourseServiceImpl
     */
    protected function getCourseService()
    {
        return $this->biz->service('CorporateTrainingBundle:Course:CourseService');
    }

    /**
     * @return CourseSetService
     */
    protected function getCourseSetService()
    {
        return $this->biz->service('CorporateTrainingBundle:Course:CourseSetService');
    }
}
