<?php

namespace CorporateTrainingBundle\Biz\NotificationCenter\ResourceNotification;

class OfflineCourse extends BaseResourceNotification
{
    public function onOfflineCourseCreate($offlineCourse)
    {
        $this->registerRemindJob($offlineCourse);
    }

    public function onOfflineCourseUpdate($offlineCourse)
    {
        $this->getSchedulerService()->deleteJobByName('OfflineCourseRemindNotificationJob_'.$offlineCourse['id']);
        $this->registerRemindJob($offlineCourse);
    }

    public function onOfflineCourseDelete($offlineCourse)
    {
        $this->getSchedulerService()->deleteJobByName('OfflineCourseRemindNotificationJob_'.$offlineCourse['id']);
    }

    protected function registerRemindJob($offlineCourse)
    {
        $currentTime = time();
        $executeTime = strtotime('-1 day 08:00:00', $offlineCourse['startTime']);
        $todayExecuteTime = strtotime('08:00:00', $currentTime);

        if ($executeTime <= $todayExecuteTime && $currentTime > $todayExecuteTime) {
            return;
        }

        $job = [
            'name' => 'OfflineCourseRemindNotificationJob_'.$offlineCourse['id'],
            'source' => 'TRAININGMAIN',
            'expression' => $executeTime,
            'class' => 'CorporateTrainingBundle\Biz\NotificationCenter\Job\OfflineCourseRemindNotificationJob',
            'args' => [
                'offlineCourse' => $offlineCourse,
            ],
            'misfire_policy' => 'executing',
        ];

        $this->getSchedulerService()->register($job);
    }
}
