<?php

namespace CorporateTrainingBundle\Biz\NotificationCenter\ResourceNotification;

use AppBundle\Common\ArrayToolkit;
use CorporateTrainingBundle\Biz\PostCourse\Service\PostCourseService;

class PostCourse extends BaseResourceNotification
{
    public function onBatchCreatePostCourses($postId, $courses)
    {
        $types = [];

        if ($this->checkEmailSetting('post_assign')) {
            $types[] = 'email';
        }

        if ($this->checkDingTalkSetting('post_course_add')) {
            $types[] = 'dingtalk';
        }

        if (empty($types)) {
            return;
        }

        list($to, $content) = $this->buildNotificationData($postId, $courses);

        $this->biz->offsetGet('notification_default')->send($types, $to, $content);
    }

    protected function buildNotificationData($postId, $courses)
    {
        $users = $this->getUserService()->searchUsers(
            ['postId' => $postId, 'locked' => 0],
            ['id' => 'ASC'],
            0,
            PHP_INT_MAX,
            ['id']
        );

        $courseTitles = ArrayToolkit::column($courses, 'title');
        $courseTitlesString = implode('》、《', $courseTitles);
        $courseTitlesString = '《'.$courseTitlesString.'》';

        global $kernel;
        $url = $kernel->getContainer()->get('router')->generate('study_center_my_task_learning', [], true);

        $to = [
            'type' => 'user',
            'userIds' => ArrayToolkit::column($users, 'id'),
            'startNum' => 0,
            'perPageNum' => 20,
        ];
        $content = [
            'template' => 'post_course_add',
            'params' => [
                'targetId' => $postId,
                'batch' => 'post_course'.$postId.time(),
                'num' => count($courses),
                'courseTitlesString' => $courseTitlesString,
                'url' => $url,
            ],
        ];

        return [$to, $content];
    }

    /**
     * @return PostCourseService
     */
    protected function getPostCourseService()
    {
        return $this->biz->service('CorporateTrainingBundle:PostCourse:PostCourseService');
    }
}
