<?php

namespace CorporateTrainingBundle\Biz\NotificationCenter\ResourceNotification;

class ProjectPlan extends BaseResourceNotification
{
    /**
     * 管理员直接添加
     *
     * @param $projectPlanId
     * @param $userIds
     * @param $dingTalkNotificationSetting
     */
    public function onAdminSelectUsers($projectPlanId, $userIds, $dingTalkNotificationSetting)
    {
        $projectPlan = $this->getProjectPlanService()->getProjectPlan($projectPlanId);

        if (empty($userIds) || empty($projectPlan)) {
            return;
        }
        $this->sendEnrollSuccessSmsNotification($userIds, "培训项目《{$projectPlan['name']}》");

        if ($this->checkEmailSetting('enroll')) {
            $types[] = 'email';
        }

        if ($dingTalkNotificationSetting && $this->checkDingTalkSetting('project_plan_assign')) {
            $types[] = 'dingtalk';
        }

        $projectPlan = $this->getProjectPlanService()->getProjectPlan($projectPlanId);

        if (empty($types)) {
            return;
        }

        list($to, $content) = $this->buildNotificationData($projectPlan, $userIds, 'project_plan_assign');
        $this->biz->offsetGet('notification_default')->send($types, $to, $content);
    }

    public function onBecomeProjectPlanMember($member)
    {
        $projectPlan = $this->getProjectPlanService()->getProjectPlan($member['projectPlanId']);

        if (empty($member) || empty($projectPlan) || 'published' != $projectPlan['status']) {
            return;
        }

        $this->getNotificationService()->notify($member['userId'], 'projectPlan_become_member', $projectPlan);
    }

    /**
     * 通过审核
     *
     * @param $projectPlanId
     * @param $userIds
     */
    public function onPassProjectPlanApplies($projectPlanId, $userIds)
    {
        $projectPlan = $this->getProjectPlanService()->getProjectPlan($projectPlanId);

        if (empty($userIds) || empty($projectPlan)) {
            return;
        }
        $this->sendEnrollSuccessSmsNotification($userIds, "培训项目《{$projectPlan['name']}》");

        if ($this->checkEmailSetting('enroll')) {
            $types[] = 'email';
        }

        if ($this->checkDingTalkSetting('project_plan_apply')) {
            $types[] = 'dingtalk';
        }
        if (empty($types)) {
            return;
        }
        list($to, $content) = $this->buildNotificationData($projectPlan, $userIds, 'email_project_plan_enroll_result');
        $this->biz->offsetGet('notification_default')->send($types, $to, $content);
    }

    /**
     * 拒绝报名
     *
     * @param $projectPlanId
     * @param $userIds
     * @param string $rejectedReason
     */
    public function onRejectProjectPlanApplies($projectPlanId, $userIds, $rejectedReason = '')
    {
        $projectPlan = $this->getProjectPlanService()->getProjectPlan($projectPlanId);

        if (empty($userIds) || empty($projectPlan)) {
            return;
        }

        $projectPlan['rejectedReason'] = $rejectedReason;
        $this->sendEnrollRejectSmsNotification($userIds, "培训项目《{$projectPlan['name']}》", $rejectedReason);
        $this->sendRejectWebNotifications($userIds, $projectPlan);

        if ($this->checkEmailSetting('enroll')) {
            $types[] = 'email';
        }
        if ($this->checkDingTalkSetting('project_plan_apply')) {
            $types[] = 'dingtalk';
        }
        if (empty($types)) {
            return;
        }

        list($to, $content) = $this->buildNotificationData($projectPlan, $userIds, 'email_project_plan_enroll_reject');

        $content['params']['rejectedReason'] = $rejectedReason;

        $this->biz->offsetGet('notification_default')->send($types, $to, $content);
    }

    /**
     * 进入补位
     *
     * @param $projectPlanId
     * @param $userIds
     * @param string $type 通过什么方式进补位的，审核review还是直接提交submit
     */
    public function onEnrollToQueueList($projectPlanId, $userIds, $type = 'submit')
    {
        if ($this->checkEmailSetting('enroll')) {
            $types[] = 'email';
        }
        if ($this->checkDingTalkSetting('project_plan_apply')) {
            $types[] = 'dingtalk';
        }
        $projectPlan = $this->getProjectPlanService()->getProjectPlan($projectPlanId);
        if (empty($userIds) || empty($projectPlan)) {
            return;
        }

        list($to, $content) = $this->buildNotificationData($projectPlan, $userIds, 'resource_enroll_queue');
        $params = [
            'resourceType' => '培训项目',
            'title' => '项目名称',
            'targetType' => 'projectPlan',
            'resourceTitle' => $projectPlan['name'],
            'content' => 'review' == $type ? '通过审核，' : '',
            'type' => $type,
        ];
        $content['params'] = array_merge($content['params'], $params);
        $smsContent = "培训项目《{$projectPlan['name']}》".$params['content'];
        foreach ($userIds as $userId) {
            $queueNum = $this->getEnrollRecordService()->getUserQueueCountByTargetIdAndTargetType($userId, $projectPlanId, 'projectPlan');
            $this->sendEnrollQueueSmsNotification($userId, $smsContent, $queueNum);
            if (empty($types)) {
                continue;
            }
            $to['userIds'] = [$userId];
            $content['params']['queueNum'] = $queueNum;
            $this->biz->offsetGet('notification_default')->send($types, $to, $content);
        }
    }

    public function onProjectPlanItemSet($projectPlanId)
    {
        $projectPlan = $this->getProjectPlanService()->getProjectPlan($projectPlanId);

        $this->sendContentMailNotification($projectPlan);
    }

    protected function sendRejectWebNotifications($userIds, $projectPlan)
    {
        foreach ($userIds as $userId) {
            $this->getNotificationService()->notify($userId, 'reject_project_plan_apply', $projectPlan);
        }
    }

    protected function buildNotificationData($projectPlan, $userIds, $template)
    {
        $url = $this->generateUrl('project_plan_detail', ['id' => $projectPlan['id']], true);

        $to = [
            'type' => 'user',
            'userIds' => $userIds,
            'startNum' => 0,
            'perPageNum' => 20,
        ];
        $content = [
            'template' => $template,
            'params' => [
                'batch' => $template.$projectPlan['id'].time(),
                'targetId' => $projectPlan['id'],
                'imagePath' => empty($projectPlan['cover']['large']) ? '' : $projectPlan['cover']['large'],
                'projectPlanName' => $projectPlan['name'],
                'url' => $url,
            ],
        ];

        return [$to, $content];
    }

    protected function sendContentMailNotification($projectPlan)
    {
        if (!$this->checkEmailSetting('project_plan_content')) {
            return;
        }

        $url = $this->generateUrl('study_center_my_task_training_list', [], true);

        $to = [
            'type' => 'project_plan',
            'projectPlanId' => $projectPlan['id'],
            'startNum' => 0,
            'perPageNum' => 20,
        ];
        $content = [
            'template' => 'train_resource_update',
            'params' => [
                'trainResourceType' => '培训项目',
                'trainResourceName' => $projectPlan['name'],
                'url' => $url,
            ],
        ];

        $this->biz->offsetGet('notification_email')->send($to, $content);
    }
}
