<?php

namespace CorporateTrainingBundle\Biz\NotificationCenter\ResourceNotification;

class ResourceQuestionnaire extends BaseResourceNotification
{
    public function onResourceQuestionnaireCreate($item, $type)
    {
        $this->registerResourceQuestionnaireRemindJob($item, $type);
        $this->registerResourceQuestionnaireUrgeNotificationJob($item, $type);
    }

    public function onResourceQuestionnaireUpdate($item, $type)
    {
        $this->getSchedulerService()->deleteJobByName('ResourceQuestionnaireRemindNotificationJob_'.$type.$item['id']);
        $this->getSchedulerService()->deleteJobByName('ResourceQuestionnaireUrgeNotificationJob_'.$type.$item['id']);
        $this->registerResourceQuestionnaireRemindJob($item, $type);
        $this->registerResourceQuestionnaireUrgeNotificationJob($item, $type);
    }

    public function onResourceQuestionnaireDelete($item, $type)
    {
        $this->getSchedulerService()->deleteJobByName('ResourceQuestionnaireRemindNotificationJob_'.$type.$item['id']);
        $this->getSchedulerService()->deleteJobByName('ResourceQuestionnaireUrgeNotificationJob_'.$type.$item['id']);
    }

    protected function registerResourceQuestionnaireRemindJob($item, $type)
    {
        if ($item['startTime'] < time()) {
            return;
        }
        if ('offlineClass' == $type) {
            $url = $this->generateUrl('offline_class_evaluation_do_survey', ['offlineClassId' => $item['offlineClassId'], 'itemId' => $item['id']], true);
        } elseif ('projectPlan' == $type) {
            $url = $this->generateUrl('project_plan_evaluation_do_survey', ['projectPlanItemId' => $item['id']], true);
        } else {
            return true;
        }
        $job = [
            'name' => 'ResourceQuestionnaireRemindNotificationJob_'.$type.$item['id'],
            'source' => 'TRAININGMAIN',
            'expression' => intval($item['startTime']),
            'class' => 'CorporateTrainingBundle\Biz\NotificationCenter\Job\ResourceSurveyRemindNotificationJob',
            'args' => [
                'item' => $item,
                'type' => $type,
                'url' => $url,
            ],
            'misfire_policy' => 'executing',
        ];

        $this->getSchedulerService()->register($job);
    }

    protected function registerResourceQuestionnaireUrgeNotificationJob($item, $type)
    {
        if ($item['startTime'] < time()) {
            return;
        }
        $executeTime = strtotime('+1 day 08:00:00', $item['startTime']);

        if ('offlineClass' == $type) {
            $url = $this->generateUrl('offline_class_evaluation_do_survey', ['offlineClassId' => $item['offlineClassId'], 'itemId' => $item['id']], true);
        } elseif ('projectPlan' == $type) {
            $url = $this->generateUrl('project_plan_evaluation_do_survey', ['projectPlanItemId' => $item['id']], true);
        }

        $job = [
            'name' => 'ResourceQuestionnaireUrgeNotificationJob_'.$type.$item['id'],
            'source' => 'TRAININGMAIN',
            'expression' => '0 8 * * *',
            'class' => 'CorporateTrainingBundle\Biz\NotificationCenter\Job\ResourceSurveyUrgeNotificationJob',
            'args' => [
                'item' => $item,
                'type' => $type,
                'url' => $url,
            ],
            'misfire_policy' => 'executing',
        ];
        $job = $this->getSchedulerService()->register($job);
        $this->getJobDao()->update($job['id'], ['next_fire_time' => $executeTime]);
    }
}
