<?php

namespace CorporateTrainingBundle\Biz\NotificationCenter\Strategy\Group;

use Biz\System\Service\LogService;
use AppBundle\Common\ArrayToolkit;
use Biz\System\Service\SettingService;
use Biz\User\Service\UserService;
use Codeages\Biz\Framework\Context\Biz;

abstract class GroupStrategy
{
    protected $biz;

    public function __construct(Biz $biz)
    {
        $this->biz = $biz;
    }

    public function findGroupEmails($params)
    {
        list($users, $memberNum) = $this->gitResourceMembers($params);
        $emails = ArrayToolkit::column($users, 'email');

        $params['startNum'] += $params['perPageNum'];

        $group = [
            'emails' => $emails,
            'params' => $params,
            'num' => $memberNum,
        ];

        return $group;
    }

    public function findGroupDingTalkUsers($params)
    {
        $params['perPageNum'] = 100; //钉钉接口限制了彼此最大用户数
        list($users, $memberNum) = $this->gitResourceMembers($params);
        $ids = empty($users) ? [-1] : ArrayToolkit::column($users, 'id');

        $params['startNum'] += $params['perPageNum'];

        $group = [
            'ids' => $ids,
            'params' => $params,
            'num' => $memberNum,
        ];

        return $group;
    }

    public function findGroupMobiles($params)
    {
        $params['perPageNum'] = 100; //云接口限制了彼此最大用户数
        list($users, $memberNum) = $this->gitResourceMembers($params);
        $mobiles = ArrayToolkit::column($users, 'verifiedMobile');

        $params['startNum'] += $params['perPageNum'];

        $group = [
            'mobiles' => $mobiles,
            'params' => $params,
            'num' => $memberNum,
        ];

        return $group;
    }

    abstract protected function gitResourceMembers($params);

    /**
     * @return \CorporateTrainingBundle\Biz\User\Service\UserService
     */
    protected function getUserService()
    {
        return $this->createService('User:UserService');
    }

    /**
     * @return SettingService
     */
    protected function getSettingService()
    {
        return $this->createService('System:SettingService');
    }

    /**
     * @return LogService
     */
    protected function getLogService()
    {
        return $this->createService('System:LogService');
    }

    protected function createService($alias)
    {
        return $this->biz->service($alias);
    }

    protected function createDao($alias)
    {
        return $this->biz->service($alias);
    }
}
