<?php

namespace CorporateTrainingBundle\Biz\NotificationCenter\Strategy\Group\Impl;

use AppBundle\Common\ArrayToolkit;
use Biz\Classroom\Service\ClassroomService;
use CorporateTrainingBundle\Biz\NotificationCenter\Strategy\Group\Group;
use CorporateTrainingBundle\Biz\NotificationCenter\Strategy\Group\GroupStrategy;

class ClassroomGroup extends GroupStrategy implements Group
{
    protected function gitResourceMembers($params)
    {
        $startNum = $params['startNum'];
        $perPageNum = $params['perPageNum'];

        $members = $this->getClassroomService()->findClassroomStudents($params['classroomId'], $startNum, $perPageNum);
        $memberNum = $this->getClassroomService()->getClassroomStudentCount($params['classroomId']);
        if (empty($members)) {
            return null;
        }

        $users = $this->getUserService()->searchUsers(
            [
                'userIds' => ArrayToolkit::column($members, 'userId'),
                'locked' => 0,
            ],
            ['id' => 'ASC'],
            0,
            PHP_INT_MAX,
            ['id', 'email', 'verifiedMobile']
        );

        return [$users, $memberNum];
    }

    /**
     * @return ClassroomService
     */
    private function getClassroomService()
    {
        return $this->createService('Classroom:ClassroomService');
    }
}
