<?php

namespace CorporateTrainingBundle\Biz\NotificationCenter\Strategy\Group\Impl;

use AppBundle\Common\ArrayToolkit;
use Biz\Course\Service\MemberService;
use CorporateTrainingBundle\Biz\NotificationCenter\Strategy\Group\Group;
use CorporateTrainingBundle\Biz\NotificationCenter\Strategy\Group\GroupStrategy;

class CourseGroup extends GroupStrategy implements Group
{
    protected function gitResourceMembers($params)
    {
        $conditions = [
            'courseId' => $params['courseId'],
        ];
        $startNum = $params['startNum'];
        $perPageNum = $params['perPageNum'];

        $members = $this->getMemberService()->searchMembers(
            $conditions,
            ['id' => 'ASC'],
            $startNum,
            $perPageNum
        );

        $memberNum = $this->getMemberService()->countMembers($conditions);

        if (empty($members)) {
            return null;
        }

        $users = $this->getUserService()->searchUsers(
            [
                'userIds' => ArrayToolkit::column($members, 'userId'),
                'locked' => 0,
            ],
            ['id' => 'ASC'],
            0,
            PHP_INT_MAX,
            ['id', 'email', 'verifiedMobile']
        );

        return [$users, $memberNum];
    }

    /**
     * @return MemberService
     */
    protected function getMemberService()
    {
        return $this->createService('Course:MemberService');
    }
}
