<?php

namespace CorporateTrainingBundle\Biz\NotificationCenter\Strategy\Group\Impl;

use AppBundle\Common\ArrayToolkit;
use CorporateTrainingBundle\Biz\NotificationCenter\Strategy\Group\Group;
use CorporateTrainingBundle\Biz\NotificationCenter\Strategy\Group\GroupStrategy;
use CorporateTrainingBundle\Biz\OfflineActivity\Service\MemberService;
use CorporateTrainingBundle\Biz\OfflineActivity\Service\OfflineActivityService;

class OfflineActivityGroup extends GroupStrategy implements Group
{
    protected function gitResourceMembers($params)
    {
        $conditions = [
            'offlineActivityId' => $params['offlineActivityId'],
        ];
        $startNum = $params['startNum'];
        $perPageNum = $params['perPageNum'];

        $members = $this->getMemberService()->searchMembers(
            $conditions,
            ['id' => 'ASC'],
            $startNum,
            $perPageNum
        );

        $memberNum = $this->getMemberService()->countMembers($conditions);

        if (empty($members)) {
            return null;
        }

        $users = $this->getUserService()->searchUsers(
            [
                'userIds' => ArrayToolkit::column($members, 'userId'),
                'locked' => 0,
            ],
            ['id' => 'ASC'],
            0,
            PHP_INT_MAX,
            ['id', 'email', 'verifiedMobile']
        );

        return [$users, $memberNum];
    }

    /**
     * @return OfflineActivityService
     */
    protected function getOfflineActivityService()
    {
        return $this->createService('CorporateTrainingBundle:OfflineActivity:OfflineActivity');
    }

    /**
     * @return MemberService
     */
    protected function getMemberService()
    {
        return $this->createService('CorporateTrainingBundle:OfflineActivity:MemberService');
    }
}
