<?php

namespace CorporateTrainingBundle\Biz\NotificationCenter\Strategy\Group\Impl;

use CorporateTrainingBundle\Biz\NotificationCenter\Strategy\Group\Group;
use CorporateTrainingBundle\Biz\NotificationCenter\Strategy\Group\GroupStrategy;

class PostGroup extends GroupStrategy implements Group
{
    protected function gitResourceMembers($params)
    {
        $conditions = [
            'postId' => $params['postId'],
            'locked' => 0,
        ];
        $startNum = $params['startNum'];
        $perPageNum = $params['perPageNum'];

        $memberNum = $this->getUserService()->countUsers($conditions);

        $users = $this->getUserService()->searchUsers(
            $conditions,
            ['id' => 'ASC'],
            $startNum,
            $perPageNum,
            ['id', 'email', 'verifiedMobile']
        );

        if (empty($users)) {
            return null;
        }

        return [$users, $memberNum];
    }
}
