<?php

namespace CorporateTrainingBundle\Biz\NotificationCenter\Strategy\Group\Impl;

use AppBundle\Common\ArrayToolkit;
use CorporateTrainingBundle\Biz\NotificationCenter\Strategy\Group\Group;
use CorporateTrainingBundle\Biz\NotificationCenter\Strategy\Group\GroupStrategy;
use CorporateTrainingBundle\Biz\ProjectPlan\Service\MemberService;
use CorporateTrainingBundle\Biz\ProjectPlan\Service\ProjectPlanService;

class ProjectPlanGroup extends GroupStrategy implements Group
{
    protected function gitResourceMembers($params)
    {
        $conditions = [
            'projectPlanId' => $params['projectPlanId'],
        ];
        $startNum = $params['startNum'];
        $perPageNum = $params['perPageNum'];

        $members = $this->getMemberService()->searchProjectPlanMembers(
            $conditions,
            ['id' => 'ASC'],
            $startNum,
            $perPageNum
        );

        $memberNum = $this->getMemberService()->countProjectPlanMembers($conditions);

        if (empty($members)) {
            return null;
        }

        $users = $this->getUserService()->searchUsers(
            [
                'userIds' => ArrayToolkit::column($members, 'userId'),
                'locked' => 0,
            ],
            ['id' => 'ASC'],
            0,
            PHP_INT_MAX,
            ['id', 'email', 'verifiedMobile']
        );

        return [$users, $memberNum];
    }

    /**
     * @return ProjectPlanService
     */
    protected function getProjectPlanService()
    {
        return $this->createService('CorporateTrainingBundle:ProjectPlan:ProjectPlanService');
    }

    /**
     * @return MemberService
     */
    protected function getMemberService()
    {
        return $this->createService('CorporateTrainingBundle:ProjectPlan:MemberService');
    }
}
