<?php

namespace CorporateTrainingBundle\Biz\NotificationCenter\Strategy\Notification\Impl;

use CorporateTrainingBundle\Biz\NotificationCenter\QueueJob\SmsNotificationJob;
use CorporateTrainingBundle\Biz\NotificationCenter\Strategy\Notification\Notification;
use CorporateTrainingBundle\Biz\NotificationCenter\Strategy\Notification\NotificationStrategy;

class SmsNotificationStrategy extends NotificationStrategy implements Notification
{
    public function send($to, $content)
    {
        $smsNotificationJob = new SmsNotificationJob(
            [
                'to' => $to,
                'content' => $content,
            ],
            [
                'timeout' => 300,
            ]
        );
        $this->getQueueService()->pushJob($smsNotificationJob, 'database');
    }
}
