<?php

namespace CorporateTrainingBundle\Biz\OfflineActivity\Event;

use Biz\User\Service\NotificationService;
use Codeages\Biz\Framework\Event\Event;
use Codeages\PluginBundle\Event\EventSubscriber;
use CorporateTrainingBundle\Biz\OfflineActivity\Service\OfflineActivityService;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class OfflineActivityMemberEventSubscriber extends EventSubscriber implements EventSubscriberInterface
{
    public static function getSubscribedEvents()
    {
        return [
            'offline.create.member' => 'onCreateMember',
        ];
    }

    public function onCreateMember(Event $event)
    {
        $member = $event->getSubject();
        $offlineActivity = $this->getOfflineActivityService()->getOfflineActivity($member['offlineActivityId']);

        if (empty($member) || empty($offlineActivity)) {
            return;
        }

        $this->notifyBecomeMember($member['userId'], $offlineActivity);
    }

    protected function notifyBecomeMember($userId, $offlineActivity)
    {
        $this->getNotificationService()->notify($userId, 'offline_activity_become_member', $offlineActivity);
    }

    /**
     * @return OfflineActivityService
     */
    protected function getOfflineActivityService()
    {
        return $this->getBiz()->service('CorporateTrainingBundle:OfflineActivity:OfflineActivityService');
    }

    /**
     * @return NotificationService
     */
    protected function getNotificationService()
    {
        return $this->getBiz()->service('User:NotificationService');
    }
}
