<?php

namespace CorporateTrainingBundle\Biz\OfflineActivity\Service;

interface MemberService
{
    public function createMember($member);

    public function updateMember($id, $fields);

    public function deleteMember($id);

    public function getMember($memberId);

    public function countMembers($conditions);

    public function searchMembers(array $conditions, array $orderBys, $start, $limit, $columns = []);

    public function findMembersByOfflineActivityId($activityId);

    public function getMemberByActivityIdAndUserId($activityId, $userId);

    public function batchBecomeMember($activityId, $userIds);

    public function isMember($activityId, $userId);

    public function attendMember($id, $attendedStatus);

    public function signIn($id);

    public function gradeMember($id, $fields);

    public function statisticMembersAttendStatusByActivityId($activityId);

    public function statisticMemberPassStatusByActivityId($activityId);

    public function statisticMemberScoreByActivityId($activityId);

    public function findDistinctUserIdsByDate($startTime, $endTime);

    public function getOfflineActivityLearnDataForUserLearnDataExtension($conditions);
}
