<?php

namespace CorporateTrainingBundle\Biz\OfflineCourse\Dao\Impl;

use Codeages\Biz\Framework\Dao\AdvancedDaoImpl;
use CorporateTrainingBundle\Biz\OfflineCourse\Dao\MemberDao;

class MemberDaoImpl extends AdvancedDaoImpl implements MemberDao
{
    protected $table = 'offline_course_member';

    public function getByOfflineCourseIdAndUserId($offlineCourseId, $userId)
    {
        return $this->getByFields(['offlineCourseId' => $offlineCourseId, 'userId' => $userId]);
    }

    public function findByIds($ids)
    {
        return $this->findInField('id', $ids);
    }

    public function findByOfflineCourseId($offlineCourseId)
    {
        return $this->findByFields(['offlineCourseId' => $offlineCourseId]);
    }

    public function findByUserId($userId)
    {
        return $this->findByFields(['userId' => $userId]);
    }

    public function selectMemberCountGroupByStatus($conditions)
    {
        $builder = $this->createQueryBuilder($conditions)
            ->select('count(`id`) as count, status')
            ->groupBy('status');

        return $builder->execute()->fetchAll();
    }

    public function declares()
    {
        return [
            'timestamps' => ['createdTime', 'updatedTime'],
            'orderbys' => ['id', 'createdTime', 'updatedTime'],
            'conditions' => [
                'id = :id',
                'status = :status',
                'offlineCourseId = :offlineCourseId',
                'offlineCourseId IN ( :offlineCourseIds )',
                'userId = :userId',
                'id IN ( :ids )',
                'userId IN ( :userIds )',
                'learnedNum = :learnedNum',
                'status <> ( :excludeStatus )',
                'learnedNum >= :learnedNumGreaterThan',
                'learnedNum < :learnedNumLessThan',
            ],
        ];
    }
}
