<?php

namespace CorporateTrainingBundle\Biz\OfflineCourse\Dao\Impl;

use Codeages\Biz\Framework\Dao\AdvancedDaoImpl;
use CorporateTrainingBundle\Biz\OfflineCourse\Dao\OfflineCourseDao;

class OfflineCourseDaoImpl extends AdvancedDaoImpl implements OfflineCourseDao
{
    protected $table = 'offline_course';

    public function findByIds($ids)
    {
        return $this->findInField('id', $ids);
    }

    public function findByTemplateId($templateId)
    {
        return $this->findByFields(['templateId' => $templateId]);
    }

    public function findRecentlyCourses($limit)
    {
        $sql = "SELECT * FROM `offline_course` where endTime >= ? and startTime <= ? ORDER BY startTime ASC LIMIT $limit";

        $parameter = [time(), time()];

        return $this->db()->fetchAll($sql, $parameter);
    }

    public function findPublishedOfflineCoursesByTeacherIdAndTimeRange($teacherId, $timeRange)
    {
        $sql = "SELECT c.* FROM `offline_course` c WHERE c.teacherId = ? AND c.status = 'published' AND ((c.startTime >= ? AND c.startTime <= ?) OR (c.endTime >= ? AND c.endTime <= ?) OR (c.startTime <= ? AND c.endTime >= ?))";

        $parameters = array_merge([$teacherId], array_values($timeRange), array_values($timeRange), array_values($timeRange));

        return $this->db()->fetchAll($sql, $parameters);
    }

    public function findCourseByUserIds($userIds)
    {
        $marks = str_repeat('?,', count($userIds) - 1).'?';

        $sql = "SELECT c.* FROM offline_course_member m LEFT JOIN offline_course c on m.offlineCourseId = c.id WHERE m.userId IN ({$marks})";

        return $this->db()->fetchAll($sql, $userIds ?: []);
    }

    public function statisticsOfflineCourseTimeByTimeRangeAndCourseIds($timeRange, $courseIds)
    {
        $offlineCourseMarks = str_repeat('?,', count($courseIds) - 1).'?';

        $sql = "SELECT SUM(time) AS offlineCourseTime FROM {$this->table} WHERE id IN ({$offlineCourseMarks}) AND (startTime >= ? AND endTime <= ?)";

        $parameters = array_merge($courseIds, array_values($timeRange));

        return $this->db()->fetchColumn($sql, $parameters);
    }

    public function countPublishedOfflineClassOrProjectPlanOfflineCourses($conditions)
    {
        $where = $this->isTableExists('offline_class') ? '(offline_course.targetType="offlineClass" and offline_course.targetId in (select ocl.id from `offline_class` ocl where ocl.status="published")) or (offline_course.targetType="projectPlan" and offline_course.targetId in (select pp.id from `project_plan` pp where pp.status="published"))'
            : 'offline_course.targetType="projectPlan" and offline_course.targetId in (select pp.id from `project_plan` pp where pp.status="published")';

        $builder = $this->createQueryBuilder($conditions)
            ->select('count(*)')
            ->andStaticWhere($where);

        return (int) $builder->execute()->fetchColumn(0);
    }

    public function searchPublishedOfflineClassOrProjectPlanOfflineCourses($conditions, $start, $limit)
    {
        $where = $this->isTableExists('offline_class') ? '(offline_course.targetType="offlineClass" and offline_course.targetId in (select ocl.id from `offline_class` ocl where ocl.status="published")) or (offline_course.targetType="projectPlan" and offline_course.targetId in (select pp.id from `project_plan` pp where pp.status="published"))'
            : 'offline_course.targetType="projectPlan" and offline_course.targetId in (select pp.id from `project_plan` pp where pp.status="published")';

        $builder = $this->createQueryBuilder($conditions)
            ->select('offline_course.*')
            ->andStaticWhere($where)
            ->orderBy('startTime', 'DESC')
            ->setFirstResult($start)
            ->setMaxResults($limit);

        return $builder->execute()->fetchAll();
    }

    public function declares()
    {
        return [
            'timestamps' => ['createdTime', 'updatedTime', 'endTime', 'startTime'],
            'serializes' => [
                'teacherIds' => 'delimiter',
                'cover' => 'json',
            ],
            'orderbys' => ['id', 'createdTime', 'updatedTime', 'endTime', 'startTime'],
            'conditions' => [
                'id = :id',
                'userId = :userId',
                'status = :status',
                'creator = : creator',
                'teacherId = :teacherId',
                'templateId = :templateId',
                'createdTime >= :startTime',
                'createdTime <= :endTime',
                'id IN ( :ids )',
                'projectPlanId IN ( :projectPlanIds)',
                'status IN ( :statuses)',
                'status NOT IN ( :excludeStatuses)',
                'title LIKE :likeTitle',
                'startTime >= :startTime_GE',
                'startTime <= :startTime_LE',
                'endTime <= :endTime_LE',
                'endTime > :endTime_GE',
                'targetId = :targetId',
                'targetType = :targetType',
                'autoAttendanceStatus = :autoAttendanceStatus',
            ],
        ];
    }

    private function isTableExists($table)
    {
        $sql = "SHOW TABLES LIKE '{$table}'";
        $result = $this->db()->fetchAssoc($sql);

        return empty($result) ? false : true;
    }
}
