<?php

namespace CorporateTrainingBundle\Biz\OfflineCourse\Dao\Impl;

use Codeages\Biz\Framework\Dao\AdvancedDaoImpl;
use CorporateTrainingBundle\Biz\OfflineCourse\Dao\OfflineCourseSurveyDao;

class OfflineCourseSurveyDaoImpl extends AdvancedDaoImpl implements OfflineCourseSurveyDao
{
    protected $table = 'offline_course_survey';

    public function getBySurveyId($surveyId)
    {
        return $this->getByFields(['surveyId' => $surveyId]);
    }

    public function findByIds($ids)
    {
        return $this->findInField('id', $ids);
    }

    public function findByOfflineCourseId($offlineCourseId)
    {
        return $this->findByFields(['offlineCourseId' => $offlineCourseId]);
    }

    public function findByOfflineCourseIds($offlineCourseIds)
    {
        return $this->findInField('offlineCourseId', $offlineCourseIds);
    }

    public function findByTargetIdAndTargetType($targetId, $targetType)
    {
        return $this->findByFields(['targetId' => $targetId, 'targetType' => $targetType]);
    }

    public function findByTargetIdsAndTargetType($targetIds, $targetType)
    {
        $marks = str_repeat('?,', count($targetIds) - 1).'?';
        $sql = "SELECT * FROM {$this->table} WHERE `targetType` = ? AND `targetId` IN ({$marks})";

        return $this->db()->fetchAll($sql, array_merge([$targetType], $targetIds) ?: []);
    }

    public function deleteByTargetIdAndTargetType($targetId, $targetType)
    {
        $sql = "DELETE FROM {$this->table} WHERE `targetId`= ? AND `targetType` = ?";

        return $this->db()->executeUpdate($sql, [$targetId, $targetType]);
    }

    public function declares()
    {
        return [
            'timestamps' => ['createdTime', 'updatedTime'],
            'orderbys' => ['id', 'createdTime'],
            'conditions' => [
                'id = :id',
                'offlineCourseId = :offlineCourseId',
                'offlineCourseId IN ( :offlineCourseIds )',
                'targetId = :targetId',
                'id IN ( :ids )',
                'targetId = :targetId',
                'targetId IN ( :targetIds )',
                'surveyId IN ( :surveyIds )',
                'targetType = :targetType',
                'surveyId = :surveyId',
            ],
        ];
    }
}
