<?php

namespace CorporateTrainingBundle\Biz\OfflineCourse\Dao\Impl;

use Codeages\Biz\Framework\Dao\AdvancedDaoImpl;
use CorporateTrainingBundle\Biz\OfflineCourse\Dao\TaskDao;

class TaskDaoImpl extends AdvancedDaoImpl implements TaskDao
{
    protected $table = 'offline_course_task';

    public function findByIds($ids)
    {
        return $this->findInField('id', $ids);
    }

    public function findByOfflineCourseId($offlineCourseId)
    {
        return $this->findByFields(['offlineCourseId' => $offlineCourseId]);
    }

    public function findByOfflineCourseIdAndTimeRange($offlineCourseId, $timeRange)
    {
        $sql = "SELECT * FROM {$this->table} WHERE offlineCourseId = ? AND ((? > startTime AND endTime > ?) OR (? <= startTime AND startTime <= ?) OR (? <= endTime AND endTime <= ?))";

        return $this->db()->fetchAll($sql, [$offlineCourseId, $timeRange['startTime'], $timeRange['endTime'], $timeRange['startTime'], $timeRange['endTime'], $timeRange['startTime'], $timeRange['endTime']]);
    }

    public function countStartTimeAndEndTimeAllInOfflineCourseTime($timeRange, $courseIds)
    {
        $offlineCourseMarks = str_repeat('?,', count($courseIds) - 1).'?';

        $sql = "SELECT SUM(t.endTime - t.startTime) AS offlineCourseTime FROM {$this->table} t WHERE t.offlineCourseId IN ({$offlineCourseMarks}) AND (t.startTime >= ? AND t.endTime <= ?) AND type = 'offlineCourse'";

        $parameters = array_merge($courseIds, array_values($timeRange));

        return $this->db()->fetchAll($sql, $parameters);
    }

    public function countStartTimeEarlierThanSearchStartTimeOfflineCourseTime($timeRange, $courseIds)
    {
        $offlineCourseMarks = str_repeat('?,', count($courseIds) - 1).'?';

        $sql = "SELECT SUM(t.endTime - ?) AS offlineCourseTime FROM {$this->table} t WHERE t.offlineCourseId IN ({$offlineCourseMarks}) AND (t.startTime < ? AND t.endTime > ? AND t.endTime < ?) AND type = 'offlineCourse'";

        $parameters = array_merge([$timeRange['startTime']], $courseIds, [$timeRange['startTime']], array_values($timeRange));

        return $this->db()->fetchAll($sql, $parameters);
    }

    public function countEndTimeLaterThanSearchEndTimeOfflineCourseTime($timeRange, $courseIds)
    {
        $offlineCourseMarks = str_repeat('?,', count($courseIds) - 1).'?';

        $sql = "SELECT SUM(? - t.startTime) AS offlineCourseTime FROM {$this->table} t WHERE t.offlineCourseId IN ({$offlineCourseMarks}) AND (t.startTime > ? AND t.startTime < ? AND t.endTime > ?) AND type = 'offlineCourse'";

        $parameters = array_merge([$timeRange['endTime']], $courseIds, array_values($timeRange), [$timeRange['endTime']]);

        return $this->db()->fetchAll($sql, $parameters);
    }

    public function countStartTimeAndEndTimeAllOutOfflineCourseTime($timeRange, $courseIds)
    {
        $offlineCourseMarks = str_repeat('?,', count($courseIds) - 1).'?';

        $sql = "SELECT SUM(? - ?) AS offlineCourseTime FROM {$this->table} t WHERE t.offlineCourseId IN ({$offlineCourseMarks}) AND (t.startTime < ? AND t.endTime > ?) AND type = 'offlineCourse'";

        $parameters = array_merge([$timeRange['endTime']], [$timeRange['startTime']], $courseIds, array_values($timeRange));

        return $this->db()->fetchAll($sql, $parameters);
    }

    public function declares()
    {
        return [
            'timestamps' => ['createdTime', 'updatedTime'],
            'orderbys' => ['id', 'createdTime', 'updatedTime', 'startTime', 'seq', 'offlineCourseId'],
            'conditions' => [
                'id = :id',
                'offlineCourseId = :offlineCourseId',
                'offlineCourseId IN ( :offlineCourseIds )',
                'status = :status',
                'type = :type',
                'type IN ( :types)',
                'id IN ( :ids )',
                'startTime >= :startTime_GE',
                'startTime <= :startTime_LE',
                'endTime >= :endTime_GE',
                'endTime <= :endTime_LE',
                'status IN ( :statuses )',
                'orgId = :orgId',
                'orgId IN ( :orgIds )',
            ],
        ];
    }
}
