<?php

namespace CorporateTrainingBundle\Biz\OfflineCourse\Dao\Impl;

use Codeages\Biz\Framework\Dao\AdvancedDaoImpl;
use CorporateTrainingBundle\Biz\OfflineCourse\Dao\TaskResultDao;

class TaskResultDaoImpl extends AdvancedDaoImpl implements TaskResultDao
{
    protected $table = 'offline_course_task_result';

    public function getByTaskIdAndUserId($taskId, $userId)
    {
        return $this->getByFields(['taskId' => $taskId, 'userId' => $userId]);
    }

    public function findByIds($ids)
    {
        return $this->findInField('id', $ids);
    }

    public function findByOfflineCourseId($offlineCourseId)
    {
        return $this->findByFields(['offlineCourseId' => $offlineCourseId]);
    }

    public function findByUserId($userId)
    {
        return $this->findByFields(['userId' => $userId]);
    }

    public function deleteByTaskId($taskId)
    {
        return $this->db()->delete($this->table, ['taskId' => $taskId]);
    }

    public function selectResultCountGroupByUserId($conditions)
    {
        $builder = $this->createQueryBuilder($conditions)
            ->select('count(`id`) as count, userId')
            ->groupBy('userId');

        return $builder->execute()->fetchAll();
    }

    public function selectResultCountGroupByStatus($conditions)
    {
        $builder = $this->createQueryBuilder($conditions)
            ->select('count(`id`) as count, status')
            ->groupBy('status');

        return $builder->execute()->fetchAll();
    }

    public function calculateUsersOfflineLearnTime($userIds, $offlineCourseIds, $endDateRange)
    {
        $userMarks = str_repeat('?,', count($userIds) - 1).'?';
        $offlineCourseMarks = str_repeat('?,', count($offlineCourseIds) - 1).'?';

        $sql = "SELECT m.userId AS userId, SUM(o.time) AS offlineStudyTime FROM `offline_course_member` m INNER JOIN `offline_course` o ON o.id = m.offlineCourseId WHERE m.offlineCourseId IN ({$offlineCourseMarks}) AND m.userId IN ({$userMarks}) AND (o.endTime >= ? AND o.endTime <= ?) GROUP BY m.userId";

        $parameters = array_merge($offlineCourseIds, $userIds, array_values($endDateRange));

        return $this->db()->fetchAll($sql, $parameters);
    }

    public function declares()
    {
        return [
            'timestamps' => ['createdTime', 'updatedTime'],
            'orderbys' => ['id', 'createdTime', 'updatedTime', 'taskId'],
            'conditions' => [
                'id = :id',
                'offlineCourseId = :offlineCourseId',
                'userId = :userId',
                'taskId = :taskId',
                'status = :status',
                'id IN ( :ids )',
                'userId IN ( :userIds )',
                'offlineCourseId IN ( :offlineCourseIds )',
                'status IN ( :statuses)',
                'taskId IN ( :taskIds )',
                'createdTime <= :createdTime_LE',
                'createdTime >= :createdTime_GE',
            ],
        ];
    }
}
