<?php

namespace CorporateTrainingBundle\Biz\OfflineCourse\Dao;

use Codeages\Biz\Framework\Dao\AdvancedDaoInterface;

interface OfflineCourseDao extends AdvancedDaoInterface
{
    public function findByIds($ids);

    public function findPublishedOfflineCoursesByTeacherIdAndTimeRange($teacherId, $timeRange);

    public function findCourseByUserIds($userIds);

    public function findRecentlyCourses($limit);

    public function findByTemplateId($templateId);

    public function statisticsOfflineCourseTimeByTimeRangeAndCourseIds($timeRange, $courseIds);

    public function countPublishedOfflineClassOrProjectPlanOfflineCourses($conditions);

    public function searchPublishedOfflineClassOrProjectPlanOfflineCourses($conditions, $start, $limit);
}
