<?php

namespace CorporateTrainingBundle\Biz\OfflineCourse\Event;

use AppBundle\Common\ArrayToolkit;
use Codeages\Biz\Framework\Event\Event;
use Codeages\PluginBundle\Event\EventSubscriber;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class OfflineCourseEventSubscriber extends EventSubscriber implements EventSubscriberInterface
{
    public static function getSubscribedEvents()
    {
        return [
            'offline_course.task.create' => 'onOfflineCourseCreateTask',
            'offline_course.task.update' => 'onOfflineCourseUpdateTask',
            'offline_course.task.delete' => 'onOfflineCourseDeleteTask',
            'offline_course.teacher.set' => 'onOfflineCourseSetTeacher',
            'offline_class.update' => 'onOfflineClassUpdate',
            'offline.course.sign_in' => 'onOfflineCourseSignIn',
        ];
    }

    public function onOfflineCourseCreateTask(Event $event)
    {
        $task = $event->getSubject();
        $this->changeTaskNum($task);
        $this->changeTime($task);
    }

    public function onOfflineCourseUpdateTask(Event $event)
    {
        $task = $event->getSubject();
        $this->changeTime($task);
    }

    public function onOfflineCourseDeleteTask(Event $event)
    {
        $task = $event->getSubject();
        $this->changeOfflineCourseMember($task);
        $this->getOfflineCourseTaskService()->deleteTaskResultByTaskId($task['id']);
        $this->changeTaskNum($task);
        $this->changeTime($task);
        $this->changeTaskSeq($task);
    }

    public function onOfflineCourseSetTeacher(Event $event)
    {
        $offlineCourse = $event->getSubject();
        $oldOfflineCourse = $event->getArgument('oldOfflineCourse');

        if ($offlineCourse['teacherId'] == $oldOfflineCourse['teacherId']) {
            return true;
        }
        $this->getNotificationService()->notify($offlineCourse['teacherId'], 'offline_course_set_teacher', $offlineCourse);
    }

    public function onOfflineClassUpdate(Event $event)
    {
        $offlineClass = $event->getSubject();

        $this->getOfflineCourseDao()->update($offlineClass['offlineCourseId'], [
            'startTime' => $offlineClass['startTime'],
            'endTime' => $offlineClass['endTime'],
            'place' => $offlineClass['place'],
        ]);
    }

    public function onOfflineCourseSignIn(Event $event)
    {
        $offlineCourse = $event->getSubject();
        $userId = $event->getArgument('userId');
        $tasks = $this->getOfflineCourseTaskService()->searchTasks(['offlineCourseId' => $offlineCourse['id'], 'type' => 'sign'], [], 0, PHP_INT_MAX);
        $member = $this->getOfflineCourseMemberService()->getMemberByOfflineCourseIdAndUserId($offlineCourse['id'], $userId);
        if (empty($tasks) || empty($member)) {
            return true;
        }
        $taskResultCount = $this->getOfflineCourseTaskService()->countTaskResults(['offlineCourseId' => $offlineCourse['id'], 'taskIds' => ArrayToolkit::column($tasks, 'id'), 'userId' => $userId, 'status' => 'finished']);

        if (count($tasks) == $taskResultCount) {
            $this->getOfflineCourseMemberService()->updateMember($member['id'], ['status' => 'attended']);
        }
    }

    protected function changeOfflineCourseMember($task)
    {
        $offlineCourse = $this->getOfflineCourseService()->getOfflineCourse($task['offlineCourseId']);
        $projectPlanMembers = $this->getProjectPlanMemberService()->findMembersByProjectPlanId($offlineCourse['targetId']);
        foreach ($projectPlanMembers as  $projectPlanMember) {
            $offlineCourseMember = $this->getOfflineCourseMemberService()->getMemberByOfflineCourseIdAndUserId($task['offlineCourseId'], $projectPlanMember['userId']);
            $this->getOfflineCourseTaskService()->getTaskResultByTaskIdAndUserId($task['id'], $projectPlanMember['userId']);
            $this->getOfflineCourseMemberService()->batchUpdateMembersLearnedNum([$offlineCourseMember['id']]);
        }
    }

    protected function changeTaskNum($task)
    {
        $this->getOfflineCourseService()->updateOfflineCourse($task['offlineCourseId'], ['taskNum' => $this->getOfflineCourseTaskService()->countTasks(['offlineCourseId' => $task['offlineCourseId']])]);
    }

    protected function changeTime($task)
    {
        $offlineCourse = $this->getOfflineCourseService()->getOfflineCourse($task['offlineCourseId']);
        $item = $this->getProjectPlanService()->getProjectPlanItemByProjectPlanIdAndTargetIdAndTargetType($offlineCourse['targetId'], $offlineCourse['id'], 'offline_course');
        if (empty($item)) {
            return;
        }

        $this->getProjectPlanService()->updateProjectPlanItemTime($item['id'], ['startTime' => $offlineCourse['startTime'], 'endTime' => $offlineCourse['endTime']]);
    }

    protected function changeTaskSeq($task)
    {
        $tasks = $this->getOfflineCourseTaskService()->searchTasks(
            ['offlineCourseId' => $task['offlineCourseId']],
            ['seq' => 'ASC'],
            0,
            PHP_INT_MAX
        );
        $taskIds = ArrayToolkit::column($tasks, 'id');
        $this->getOfflineCourseTaskService()->sortTasks($taskIds);
    }

    /**
     * @return \CorporateTrainingBundle\Biz\OfflineCourse\Service\Impl\TaskServiceImpl
     */
    protected function getOfflineCourseTaskService()
    {
        return $this->getBiz()->service('CorporateTrainingBundle:OfflineCourse:TaskService');
    }

    /**
     * @return \CorporateTrainingBundle\Biz\OfflineCourse\Service\Impl\OfflineCourseServiceImpl
     */
    protected function getOfflineCourseService()
    {
        return $this->getBiz()->service('CorporateTrainingBundle:OfflineCourse:OfflineCourseService');
    }

    /**
     * @return \CorporateTrainingBundle\Biz\OfflineCourse\Dao\OfflineCourseDao
     */
    protected function getOfflineCourseDao()
    {
        return $this->getBiz()->dao('CorporateTrainingBundle:OfflineCourse:OfflineCourseDao');
    }

    /**
     * @return \CorporateTrainingBundle\Biz\OfflineCourse\Service\Impl\MemberServiceImpl
     */
    protected function getOfflineCourseMemberService()
    {
        return $this->getBiz()->service('CorporateTrainingBundle:OfflineCourse:MemberService');
    }

    /**
     * @return \CorporateTrainingBundle\Biz\ProjectPlan\Service\Impl\ProjectPlanServiceImpl
     */
    protected function getProjectPlanService()
    {
        return $this->getBiz()->service('CorporateTrainingBundle:ProjectPlan:ProjectPlanService');
    }

    /**
     * @return \CorporateTrainingBundle\Biz\ProjectPlan\Service\Impl\MemberServiceImpl
     */
    protected function getProjectPlanMemberService()
    {
        return $this->getBiz()->service('CorporateTrainingBundle:ProjectPlan:MemberService');
    }

    /**
     * @return \Biz\User\Service\Impl\NotificationServiceImpl
     */
    protected function getNotificationService()
    {
        return $this->getBiz()->service('User:NotificationService');
    }
}
