<?php

namespace CorporateTrainingBundle\Biz\OfflineCourse\Job;

use Biz\System\Service\LogService;
use Topxia\Service\Common\ServiceKernel;
use Codeages\Biz\Framework\Scheduler\AbstractJob;
use Codeages\Biz\Framework\Queue\Service\QueueService;
use CorporateTrainingBundle\Biz\OfflineCourse\Job\QueueJob\OfflineClassAttendanceJob;
use CorporateTrainingBundle\Biz\OfflineCourse\Job\QueueJob\ProjectPlanOfflineCourseAttendanceJob;

class OfflineCourseTaskAutoAttendanceJob extends AbstractJob
{
    const LIMIT = 50;

    public function execute()
    {
        $offlineCourses = $this->getOfflineCourseService()->searchOfflineCourses(['endTime_LE' => time(), 'autoAttendanceStatus' => 0], ['endTime' => 'ASC'], 0, self::LIMIT);

        foreach ($offlineCourses as $offlineCourse) {
            if ('projectPlan' == $offlineCourse['targetType']) {
                $attendanceJob = new ProjectPlanOfflineCourseAttendanceJob(
                   $offlineCourse,
                   array(
                       'timeout' => 300,
                   )
               );
                $this->getQueueService()->pushJob($attendanceJob, 'database');
                continue;
            }
            $attendanceJob = new OfflineClassAttendanceJob(
               $offlineCourse,
               array(
                   'timeout' => 300,
               )
           );
            $this->getQueueService()->pushJob($attendanceJob, 'database');
        }
    }

    /**
     * @return LogService
     */
    protected function getLogService()
    {
        return $this->biz->service('System:LogService');
    }

    /**
     * @return \CorporateTrainingBundle\Biz\OfflineCourse\Service\Impl\MemberServiceImpl
     */
    protected function getOfflineCourseMemberService()
    {
        return $this->biz->service('CorporateTrainingBundle:OfflineCourse:MemberService');
    }

    /**
     * @return \CorporateTrainingBundle\Biz\OfflineCourse\Service\Impl\OfflineCourseServiceImpl
     */
    protected function getOfflineCourseService()
    {
        return ServiceKernel::instance()->createService('CorporateTrainingBundle:OfflineCourse:OfflineCourseService');
    }

    /**
     * @return QueueService
     */
    protected function getQueueService()
    {
        return  ServiceKernel::instance()->createService('Queue:QueueService');
    }
}
