<?php

namespace CorporateTrainingBundle\Biz\OfflineCourse\Job\QueueJob;

use Biz\System\Service\LogService;
use AppBundle\Common\ArrayToolkit;
use Codeages\Biz\Framework\Queue\AbstractJob;
use Codeages\Biz\Framework\Queue\Service\QueueService;
use OfflineCourseProPlugin\Biz\OfflineClass\Dao\MemberDao;
use OfflineCourseProPlugin\Biz\OfflineClass\Service\MemberService;
use Topxia\Service\Common\ServiceKernel;

class BaseAttendanceJob extends AbstractJob
{
    const LIMIT = 2000;

    protected $offlineCourseId = 0;

    public function execute()
    {
        // TODO: Implement execute() method.
    }

    protected function processResourceMembers($offlineCourseId, $resourceMembers, $taskIds)
    {
        $this->offlineCourseId = $offlineCourseId;
        $userIds = empty($resourceMembers) ? array(-1) : ArrayToolkit::column($resourceMembers, 'userId');
        $offlineCourseMembers = $this->getOfflineCourseMemberService()->searchMembers(['offlineCourseId' => $offlineCourseId, 'userIds' => $userIds], [], 0, count($userIds));
        $offlineCourseMembers = ArrayToolkit::index($offlineCourseMembers, 'userId');
        $resultCounts = $this->getOfflineCourseTaskService()->selectResultCountGroupByUserId(['offlineCourseId' => $offlineCourseId, 'taskIds' => $taskIds, 'status' => 'finished']);
        $resultCounts = ArrayToolkit::index($resultCounts, 'userId');
        $createData = [];
        $updateData = [];
        foreach ($resourceMembers as $resourceMember) {
            if (empty($offlineCourseMembers[$resourceMember['userId']])) {
                $createData[] = [
                    'offlineCourseId' => $offlineCourseId,
                    'userId' => $resourceMember['userId'],
                    'learnedNum' => 0,
                    'status' => 'absenteeism',
                ];
                continue;
            }
            if (in_array($offlineCourseMembers[$resourceMember['userId']]['status'], ['absenteeism', 'attended', 'partial', 'leave'])) {
                continue;
            }
            $status = 'absenteeism';

            if (!empty($resultCounts[$resourceMember['userId']]) && $resultCounts[$resourceMember['userId']]['count'] == count($taskIds)) {
                $status = 'attended';
            }

            if (!empty($resultCounts[$resourceMember['userId']]) && $resultCounts[$resourceMember['userId']]['count'] < count($taskIds)) {
                $status = 'partial';
            }

            $member = $offlineCourseMembers[$resourceMember['userId']];
            $updateData[$member['id']] = ['status' => $status];
        }

        unset($resourceMembers);
        unset($offlineCourseMembers);

        return $this->processOfflineCourseMemberData($createData, $updateData);
    }

    protected function processOfflineCourseMemberData($createData, $updateData)
    {
        try {
            if (!empty($createData)) {
                $this->getMemberDao()->batchCreate($createData);
            }
            if (!empty($updateData)) {
                $this->getMemberDao()->batchUpdate(array_keys($updateData), $updateData, 'id');
            }
        } catch (\Exception $e) {
            $this->getLogService()->error('Offline_course', 'Offline_course_attendance', '线下课程自动考勤失败id:'.$this->offlineCourseId.$e->getMessage());
        }
    }

    protected function createQueueJob($context)
    {
        $context['start'] = $context['start'] + self::LIMIT;
        $attendanceJob = new self(
            $context
        );
        $this->getQueueService()->pushJob($attendanceJob, 'database');
    }

    /**
     * @return LogService
     */
    protected function getLogService()
    {
        return ServiceKernel::instance()->createService('System:LogService');
    }

    /**
     * @return \CorporateTrainingBundle\Biz\ProjectPlan\Service\Impl\MemberServiceImpl
     */
    protected function getProjectPlanMemberService()
    {
        return  ServiceKernel::instance()->createService('CorporateTrainingBundle:ProjectPlan:MemberService');
    }

    /**
     * @return \CorporateTrainingBundle\Biz\OfflineCourse\Service\Impl\MemberServiceImpl
     */
    protected function getOfflineCourseMemberService()
    {
        return  ServiceKernel::instance()->createService('CorporateTrainingBundle:OfflineCourse:MemberService');
    }

    /**
     * @return \CorporateTrainingBundle\Biz\OfflineCourse\Service\Impl\TaskServiceImpl
     */
    protected function getOfflineCourseTaskService()
    {
        return  ServiceKernel::instance()->createService('CorporateTrainingBundle:OfflineCourse:TaskService');
    }

    /**
     * @return QueueService
     */
    protected function getQueueService()
    {
        return ServiceKernel::instance()->createService('Queue:QueueService');
    }

    /**
     * @return \CorporateTrainingBundle\Biz\OfflineCourse\Dao\Impl\MemberDaoImpl
     */
    protected function getMemberDao()
    {
        return ServiceKernel::instance()->createDao('CorporateTrainingBundle:OfflineCourse:MemberDao');
    }

    /**
     * @return \CorporateTrainingBundle\Biz\OfflineCourse\Dao\Impl\OfflineCourseDaoImpl
     */
    public function getOfflineCourseDao()
    {
        return ServiceKernel::instance()->createDao('CorporateTrainingBundle:OfflineCourse:OfflineCourseDao');
    }

    /**
     * @return MemberService
     */
    protected function getOfflineClassMemberService()
    {
        return ServiceKernel::instance()->createService('OfflineCourseProPlugin:OfflineClass:MemberService');
    }
}
