<?php

namespace CorporateTrainingBundle\Biz\OfflineCourse\Job\QueueJob;

use AppBundle\Common\ArrayToolkit;

class ProjectPlanOfflineCourseAttendanceJob extends BaseAttendanceJob
{
    public function execute()
    {
        $context = $this->getBody();
        $context['start'] = isset($context['start']) ? $context['start'] : 0;
        $tasks = $this->getOfflineCourseTaskService()->searchTasks(['offlineCourseId' => $context['id'], 'type' => 'sign'], [], 0, PHP_INT_MAX, ['id']);
        $projectPlanMembers = $this->getProjectPlanMemberService()->searchProjectPlanMembers(['projectPlanId' => $context['targetId']], ['id' => 'ASC'], $context['start'], self::LIMIT);

        if (empty($tasks) || empty($projectPlanMembers)) {
            $this->getOfflineCourseDao()->update($context['id'], ['autoAttendanceStatus' => 1]);

            return true;
        }
        $taskIds = empty($tasks) ? array(-1) : ArrayToolkit::column($tasks, 'id');
        $this->processResourceMembers($context['id'], $projectPlanMembers, $taskIds);

        if (count($projectPlanMembers) < self::LIMIT) {
            return $this->getOfflineCourseDao()->update($context['id'], ['autoAttendanceStatus' => 1]);
        }

        $this->createQueueJob($context);
    }
}
