<?php

namespace CorporateTrainingBundle\Biz\OfflineCourse\Service\Impl;

use AppBundle\Common\ArrayToolkit;
use Biz\BaseService;
use CorporateTrainingBundle\Biz\OfflineCourse\Service\MemberService;
use CorporateTrainingBundle\Biz\OfflineCourse\Service\TaskService;

class MemberServiceImpl extends BaseService implements MemberService
{
    public function createMember($member)
    {
        $this->validateFields($member);
        $member = $this->filterFields($member);

        return $this->getMemberDao()->create($member);
    }

    public function updateMember($id, $fields)
    {
        $fields = $this->filterFields($fields);

        return $this->getMemberDao()->update($id, $fields);
    }

    public function deleteMember($id)
    {
        return $this->getMemberDao()->delete($id);
    }

    public function getMember($id)
    {
        return $this->getMemberDao()->get($id);
    }

    public function getMemberByOfflineCourseIdAndUserId($offlineCourseId, $userId)
    {
        return $this->getMemberDao()->getByOfflineCourseIdAndUserId($offlineCourseId, $userId);
    }

    public function findMembersByIds($ids)
    {
        return $this->getMemberDao()->findByIds($ids);
    }

    public function findMembersByOfflineCourseId($offlineCourseId)
    {
        return $this->getMemberDao()->findByOfflineCourseId($offlineCourseId);
    }

    public function findMembersByUserId($userId)
    {
        return $this->getMemberDao()->findByUserId($userId);
    }

    public function searchMembers($conditions, $orderBys, $start, $limit, $columns = [])
    {
        return $this->getMemberDao()->search($conditions, $orderBys, $start, $limit, $columns);
    }

    public function selectMemberCountGroupByStatus($conditions)
    {
        return $this->getMemberDao()->selectMemberCountGroupByStatus($conditions);
    }

    public function countMembers($conditions)
    {
        return $this->getMemberDao()->count($conditions);
    }

    public function batchUpdateMembersLearnedNum($ids)
    {
        $members = $this->findMembersByIds(array_values($ids));
        foreach ($members as $member) {
            $updateMembers[$member['id']] = [
                'learnedNum' => $this->getOfflineCourseTaskService()->countTaskResults(
                    [
                        'offlineCourseId' => $member['offlineCourseId'],
                        'userId' => $member['userId'],
                        'status' => 'finished',
                    ]
                ),
            ];
        }
        if (!empty($updateMembers)) {
            $this->getMemberDao()->batchUpdate(array_keys($updateMembers), $updateMembers, 'id');
        }

        return true;
    }

    /**
     * 批量考勤
     *
     * @param $offlineCourseId
     * @param $userIds
     * @param string $status
     *
     * @return bool
     */
    public function batchAttend($offlineCourseId, $userIds, $status = 'none')
    {
        $userIds = array_filter($userIds);
        if (empty($userIds)) {
            return true;
        }
        $members = $this->searchMembers(
            ['offlineCourseId' => $offlineCourseId, 'userIds' => $userIds],
            [],
            0,
            count($userIds)
        );
        $members = ArrayToolkit::index($members, 'userId');
        $updateMembers = [];
        $createMembers = [];
        foreach ($userIds as $userId) {
            if (!empty($members[$userId])) {
                $updateMembers[$members[$userId]['id']] = ['status' => $status];
                continue;
            }
            $createMembers[] = [
                'offlineCourseId' => $offlineCourseId,
                'userId' => $userId,
                'learnedNum' => 0,
                'status' => $status,
            ];
        }
        if (!empty($updateMembers)) {
            $this->getMemberDao()->batchUpdate(array_keys($updateMembers), $updateMembers, 'id');
        }
        if (!empty($createMembers)) {
            $this->getMemberDao()->batchCreate($createMembers);
        }
    }

    protected function validateFields($fields)
    {
        if (!ArrayToolkit::requireds($fields, ['offlineCourseId', 'userId'], true)) {
            throw $this->createInvalidArgumentException('Lack of required fields');
        }
    }

    protected function filterFields($fields)
    {
        return ArrayToolkit::parts(
            $fields,
            [
                'offlineCourseId',
                'userId',
                'learnedNum',
                'status',
            ]
        );
    }

    /**
     * @return \CorporateTrainingBundle\Biz\OfflineCourse\Dao\Impl\MemberDaoImpl
     */
    protected function getMemberDao()
    {
        return $this->createDao('CorporateTrainingBundle:OfflineCourse:MemberDao');
    }

    /**
     * @return TaskService
     */
    protected function getOfflineCourseTaskService()
    {
        return $this->createService('CorporateTrainingBundle:OfflineCourse:TaskService');
    }
}
