<?php

namespace CorporateTrainingBundle\Biz\OfflineCourse\Service\Impl;

use AppBundle\Common\ArrayToolkit;
use Biz\BaseService;
use Biz\System\Service\LogService;
use CorporateTrainingBundle\Biz\OfflineCourse\Dao\OfflineCourseSurveyDao;
use CorporateTrainingBundle\Biz\OfflineCourse\Service\OfflineCourseSurveyService;

class OfflineCourseSurveyServiceImpl extends BaseService implements OfflineCourseSurveyService
{
    public function createOfflineCourseSurvey($fields)
    {
        $this->validateFields($fields);
        $fields = $this->filterFields($fields);

        return $this->getOfflineCourseSurveyDao()->create($fields);
    }

    public function updateOfflineCourseSurvey($id, $fields)
    {
        $fields = $this->filterFields($fields);

        return $this->getOfflineCourseSurveyDao()->update($id, $fields);
    }

    public function batchCreateOfflineCourseSurvey($fields)
    {
        return $this->getOfflineCourseSurveyDao()->batchCreate($fields);
    }

    public function deleteOfflineCourseSurvey($id)
    {
        return $this->getOfflineCourseSurveyDao()->delete($id);
    }

    public function deleteOfflineCourseSurveysByTargetIdAndTargetType($targetId, $targetType)
    {
        return $this->getOfflineCourseSurveyDao()->deleteByTargetIdAndTargetType($targetId, $targetType);
    }

    public function getOfflineCourseSurvey($id)
    {
        return $this->getOfflineCourseSurveyDao()->get($id);
    }

    public function getOfflineCourseSurveyBySurveyId($surveyId)
    {
        return $this->getOfflineCourseSurveyDao()->getBySurveyId($surveyId);
    }

    public function findOfflineCourseSurveysByIds($ids)
    {
        return $this->getOfflineCourseSurveyDao()->findByIds($ids);
    }

    public function findOfflineCourseSurveysByOfflineCourseId($offlineCourseId)
    {
        return $this->getOfflineCourseSurveyDao()->findByOfflineCourseId($offlineCourseId);
    }

    public function findOfflineCourseSurveysByOfflineCourseIds($offlineCourseIds)
    {
        return $this->getOfflineCourseSurveyDao()->findByOfflineCourseIds($offlineCourseIds);
    }

    public function findOfflineCourseSurveysByTargetIdsAndTargetType($targetIds, $targetType)
    {
        return $this->getOfflineCourseSurveyDao()->findByTargetIdsAndTargetType($targetIds, $targetType);
    }

    public function findOfflineCourseSurveysByTargetIdAndTargetType($targetId, $targetType)
    {
        return $this->getOfflineCourseSurveyDao()->findByTargetIdAndTargetType($targetId, $targetType);
    }

    public function searchOfflineCourseSurveys($conditions, $orderBys, $start, $limit)
    {
        return $this->getOfflineCourseSurveyDao()->search($conditions, $orderBys, $start, $limit);
    }

    public function countOfflineCourseSurveys($conditions)
    {
        return $this->getOfflineCourseSurveyDao()->count($conditions);
    }

    protected function validateFields($fields)
    {
        if (!ArrayToolkit::requireds($fields, ['offlineCourseId', 'targetId', 'targetType', 'surveyId'], true)) {
            throw $this->createInvalidArgumentException('Lack of required fields');
        }
    }

    protected function filterFields($fields)
    {
        return ArrayToolkit::parts(
            $fields,
            [
                'offlineCourseId',
                'targetId',
                'targetType',
                'surveyId',
            ]
        );
    }

    /**
     * @return LogService
     */
    protected function getLogService()
    {
        return $this->createService('System:LogService');
    }

    /**
     * @return OfflineCourseSurveyDao
     */
    protected function getOfflineCourseSurveyDao()
    {
        return $this->createDao('CorporateTrainingBundle:OfflineCourse:OfflineCourseSurveyDao');
    }
}
