<?php

namespace CorporateTrainingBundle\Biz\OfflineCourse\Service;

interface MemberService
{
    public function createMember($member);

    public function updateMember($id, $fields);

    public function deleteMember($id);

    public function getMember($id);

    public function getMemberByOfflineCourseIdAndUserId($offlineCourseId, $userId);

    public function findMembersByIds($ids);

    public function findMembersByOfflineCourseId($offlineCourseId);

    public function findMembersByUserId($userId);

    public function searchMembers($conditions, $orderBys, $start, $limit, $columns = array());

    public function selectMemberCountGroupByStatus($conditions);

    public function countMembers($conditions);

    public function batchUpdateMembersLearnedNum($ids);

    /**
     * 批量考勤
     *
     * @param $offlineCourseId
     * @param $userIds
     * @param string $status
     *
     * @return bool
     */
    public function batchAttend($offlineCourseId, $userIds, $status = 'none');
}
