<?php

namespace CorporateTrainingBundle\Biz\OfflineCourse\Service;

interface OfflineCourseService
{
    public function createOfflineCourse($offlineCourse);

    public function updateOfflineCourse($id, $fields);

    public function deleteOfflineCourse($id);

    public function getOfflineCourse($id);

    public function findOfflineCoursesByIds($ids);

    public function searchOfflineCourses($conditions, $orderBys, $start, $limit, $columns = []);

    public function countOfflineCourses($conditions);

    public function countPublishedOfflineClassOrProjectPlanOfflineCourses($conditions);

    public function searchPublishedOfflineClassOrProjectPlanOfflineCourses($conditions, $start, $limit);

    public function publishOfflineCourse($id);

    public function closeOfflineCourse($id);

    public function setTeacher($id, $teacherId);

    public function findTeachersByOfflineCourseId($id);

    public function findTeachingOfflineCourseByUserId($userId);

    public function findPublishedOfflineCoursesByTeacherIdAndTimeRange($teacherId, $timeRange);

    public function findCourseByUserIds($userIds);

    public function buildOfflineCourseStatistic($course);

    public function findRecentlyOfflineCourses($limit = PHP_INT_MAX);

    public function findOfflineCoursesByTemplateId($templateId);

    public function statisticsOfflineCourseTimeByTimeRangeAndCourseIds($timeRange, $courseIds);
}
