<?php

namespace CorporateTrainingBundle\Biz\OfflineCourse\Service;

interface TaskService
{
    /**
     *  Task API.
     */
    public function createTask($task);

    public function updateTask($id, $fields);

    public function deleteTask($id);

    public function getTask($id);

    public function findTasksByIds($ids);

    public function findTasksByOfflineCourseId($offlineCourseId);

    public function findTasksByOfflineCourseIdAndTimeRange($offlineCourseId, $timeRange);

    public function searchTasks($conditions, $orderBys, $start, $limit, $columns = []);

    public function countTasks($conditions);

    public function sortTasks($ids);

    /**
     *  TaskResult API.
     */
    public function createTaskResult($taskResult);

    public function updateTaskResult($id, $fields);

    public function deleteTaskResult($id);

    public function deleteTaskResultByTaskId($taskId);

    public function getTaskResult($id);

    public function getTaskResultByTaskIdAndUserId($taskId, $userId);

    public function findTaskResultsByIds($ids);

    public function findTaskResultsByOfflineCourseId($offlineCourseId);

    public function findTaskResultsByUserId($userId);

    public function searchTaskResults($conditions, $orderBys, $start, $limit, $columns = array());

    public function selectResultCountGroupByUserId($conditions);

    public function selectResultCountGroupByStatus($conditions);

    public function countTaskResults($conditions);

    public function signIn($userId, $task);

    public function batchCheckHomework($taskId, $userIds, $status);

    public function submitHomework($taskResult, $attachment);

    public function getOfflineStudyHoursLearnDataForUserLearnDataExtension($conditions);
}
