<?php

namespace CorporateTrainingBundle\Biz\OfflineExam\Dao\Impl;

use Codeages\Biz\Framework\Dao\AdvancedDaoImpl;
use CorporateTrainingBundle\Biz\OfflineExam\Dao\OfflineExamDao;

class OfflineExamDaoImpl extends AdvancedDaoImpl implements OfflineExamDao
{
    protected $table = 'offline_exam';

    public function getByIdAndTimeRange($id, $timeRange)
    {
        $sql = "SELECT * FROM {$this->table} WHERE id = ? AND ((? > startTime AND endTime > ?) OR (? <= startTime AND startTime <= ?) OR (? <= endTime AND endTime <= ?))";

        return $this->db()->fetchAll($sql, [$id, $timeRange['startTime'], $timeRange['endTime'], $timeRange['startTime'], $timeRange['endTime'], $timeRange['startTime'], $timeRange['endTime']]);
    }

    public function findByIds($ids)
    {
        return $this->findInField('id', $ids);
    }

    public function declares()
    {
        return [
            'timestamps' => ['createdTime', 'updatedTime'],
            'orderbys' => ['id', 'createdTime', 'updatedTime', 'startTime', 'endTime'],
            'conditions' => [
                'id = :id',
                'id IN ( :ids )',
                'targetType = :targetType',
                'targetId = :targetId',
                'title LIKE :titleLike',
                'startTime >= :startTime_GE',
                'startTime <= :startTime_LE',
                'endTime >= :endTime_GE',
                'endTime <= :endTime_LE',
                'status = :status',
                'creator = :creator',
            ],
        ];
    }
}
