<?php

namespace CorporateTrainingBundle\Biz\Org\Job;

use Biz\System\Service\LogService;
use Codeages\Biz\Framework\Scheduler\AbstractJob;

class SyncDingTalkOrgJob extends AbstractJob
{
    public function execute()
    {
        try {
            $this->getOrgSyncService()->syncFrom();
        } catch (\Exception $e) {
            $this->getLogService()->error('dingtalk', 'dingtalk_sync_org', '钉钉同步部门失败:'.$e->getMessage());
        }
    }

    /**
     * @return LogService
     */
    protected function getLogService()
    {
        return $this->biz->service('System:LogService');
    }

    protected function getOrgSyncService()
    {
        return $this->biz->service('OrgSync:OrgSyncService');
    }
}
