<?php

namespace CorporateTrainingBundle\Biz\Org\Module;

use Biz\OpenCourse\Dao\OpenCourseDao;
use Biz\OpenCourse\Service\OpenCourseService;

class OpenCourseModule extends Module
{
    protected $type = 'openCourse';

    protected $hasVisibleOrAccessScope = 0;

    /**
     * @return OpenCourseService
     */
    protected function getResourceService()
    {
        return $this->biz->service('OpenCourse:OpenCourseService');
    }

    public function initOrgsRelation()
    {
        return true;
    }

    /**
     * @return OpenCourseDao
     */
    protected function getResourceDao()
    {
        return $this->biz->dao('OpenCourse:OpenCourseDao');
    }
}
