<?php

namespace CorporateTrainingBundle\Biz\Org\Module;

use AppBundle\Common\ArrayToolkit;
use CorporateTrainingBundle\Biz\UserGroup\Dao\MemberDao;

class UserGroupModule extends Module
{
    protected $type = 'userGroup';

    protected $memberType = 'org';

    protected $hasVisibleOrAccessScope = 0;

    public function verticalMigrate($fromOrg, $toOrg)
    {
        if (empty($fromOrg)) {
            return true;
        }
        $deletedOrgIds = [$fromOrg['id']];
        if (!empty($fromOrg['children'])) {
            $childIds = ArrayToolkit::column($fromOrg['children'], 'id');
            $deletedOrgIds = array_merge($childIds, $deletedOrgIds);
        }
        $conditions = [
            'memberIds' => $deletedOrgIds,
            'memberType' => $this->memberType,
        ];
        $this->getResourceDao()->batchDelete($conditions);
    }

    public function horizontalMigrate($orgId, $orgCode, $oldOrgCode)
    {
        return true;
    }

    public function initOrgsRelation()
    {
        $conditions = [
            'exitMemberId' => 1,
            'memberType' => $this->memberType,
        ];
        $this->getResourceDao()->batchDelete($conditions);
    }

    /**
     * @return MemberDao
     */
    protected function getResourceDao()
    {
        return $this->biz->dao('UserGroup:MemberDao');
    }
}
