<?php

namespace CorporateTrainingBundle\Biz\PostCourse\Dao\Impl;

use Codeages\Biz\Framework\Dao\GeneralDaoImpl;
use CorporateTrainingBundle\Biz\PostCourse\Dao\PostCourseDao;

class PostCourseDaoImpl extends GeneralDaoImpl implements PostCourseDao
{
    protected $table = 'post_course';

    public function deleteByPostId($postId)
    {
        $sql = "DELETE FROM {$this->table} WHERE postId = ?";

        return $this->db()->executeUpdate($sql, [$postId]);
    }

    public function deleteByCourseSetId($courseSetId)
    {
        $sql = "DELETE FROM {$this->table} WHERE courseSetId = ?";

        return $this->db()->executeUpdate($sql, [$courseSetId]);
    }

    public function getByPostIdAndCourseId($postId, $courseId)
    {
        return $this->getByFields(['postId' => $postId, 'courseId' => $courseId]);
    }

    public function getByPostIdAndCourseSetId($postId, $courseSetId)
    {
        return $this->getByFields(['postId' => $postId, 'courseSetId' => $courseSetId]);
    }

    public function findByPostId($postId)
    {
        $sql = "SELECT * FROM {$this->table} WHERE postId = ?";

        return $this->db()->fetchAll($sql, [$postId]);
    }

    public function findByCourseId($courseId)
    {
        $sql = "SELECT * FROM {$this->table} WHERE courseId = ?";

        return $this->db()->fetchAll($sql, [$courseId]);
    }

    public function declares()
    {
        return [
            'timestamps' => ['createdTime', 'updatedTime'],
            'serializes' => [],
            'orderbys' => ['id', 'seq'],
            'conditions' => [
                'courseId = :courseId',
                'postId = :postId',
                'postId IN (:postIds)',
            ],
        ];
    }
}
