<?php

namespace CorporateTrainingBundle\Biz\PostCourse\Event;

use Codeages\Biz\Framework\Event\Event;
use Codeages\PluginBundle\Event\EventSubscriber;
use CorporateTrainingBundle\Biz\PostCourse\Service\PostCourseService;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class PostCourseEventSubscriber extends EventSubscriber implements EventSubscriberInterface
{
    public static function getSubscribedEvents()
    {
        return [
            'course-set.delete' => 'onPostCoursesDelete',
        ];
    }

    public function onPostCoursesDelete(Event $event)
    {
        $courseSet = $event->getSubject();
        $this->getPostCourseService()->deletePostCoursesByCourseSetId($courseSet['id']);
    }

    /**
     * @return PostCourseService
     */
    protected function getPostCourseService()
    {
        return $this->getBiz()->service('CorporateTrainingBundle:PostCourse:PostCourseService');
    }
}
