<?php

namespace CorporateTrainingBundle\Biz\ProjectPlan\Dao\Impl;

use Codeages\Biz\Framework\Dao\AdvancedDaoImpl;
use CorporateTrainingBundle\Biz\ProjectPlan\Dao\ProjectPlanItemDao;

class ProjectPlanItemDaoImpl extends AdvancedDaoImpl implements ProjectPlanItemDao
{
    protected $table = 'project_plan_item';

    public function getByTargetIdAndTargetType($targetId, $targetType)
    {
        return $this->getByFields(['targetId' => $targetId, 'targetType' => $targetType]);
    }

    public function getByProjectPlanIdAndTargetIdAndTargetType($projectPlanId, $targetId, $targetType)
    {
        return $this->getByFields(['projectPlanId' => $projectPlanId, 'targetId' => $targetId, 'targetType' => $targetType]);
    }

    public function findByIds($ids)
    {
        return $this->findInField('id', $ids);
    }

    public function findByProjectPlanId($projectPlanId)
    {
        return $this->findByFields(['projectPlanId' => $projectPlanId]);
    }

    public function findByProjectPlanIds($projectPlanIds)
    {
        return $this->findInField('projectPlanId', $projectPlanIds);
    }

    public function findByProjectPlanIdAndTargetType($projectPlanId, $targetType)
    {
        return $this->findByFields(['projectPlanId' => $projectPlanId, 'targetType' => $targetType]);
    }

    public function findByTargetIdAndTargetType($targetId, $targetType)
    {
        return $this->findByFields(['targetId' => $targetId, 'targetType' => $targetType]);
    }

    public function findHasFinishedSurveyResultProjectPlanItemIds($projectPlanId, $userIds)
    {
        $userIdMarks = str_repeat('?,', count($userIds) - 1).'?';

        $sql = "SELECT distinct(i.id) FROM {$this->table} i INNER JOIN `activity` a INNER JOIN `plugin_survey_result` r ON a.mediaId = r.surveyId AND i.targetId = a.fromCourseId AND ((a.mediaType = 'questionnaire' AND i.targetType = 'course') OR (a.mediaType = 'offlineCourseQuestionnaire' AND i.targetType = 'offline_course')) WHERE i.projectPlanId = ? AND r.userId IN ({$userIdMarks}) AND r.status = 'finished'";

        $parameters = array_merge([$projectPlanId], $userIds);

        return $this->db()->fetchAll($sql, $parameters);
    }

    public function deleteItemByProjectPlanId($projectPlanId)
    {
        $sql = "DELETE FROM {$this->table} WHERE projectPlanId = ?";

        return $this->db()->executeUpdate($sql, [$projectPlanId]);
    }

    public function declares()
    {
        return [
            'timestamps' => ['createdTime', 'updatedTime', 'startTime'],
            'orderbys' => [
                'id',
                'createdTime',
                'updatedTime',
                'startTime',
                'endTime',
                'seq',
            ],
            'conditions' => [
                'id = :id',
                'id IN (:ids)',
                'projectPlanId = :projectPlanId',
                'targetType = :targetType',
                'targetType IN (:targetTypes)',
                'targetId = :targetId',
                'targetId IN (:targetIds)',
                'projectPlanId IN (:projectPlanIds)',
                'startTime >= :startTime_GE',
                'targetId NOT IN ( :excludeTargetIds )',
                'targetType NOT IN ( :excludeTargetTypes )',
            ],
        ];
    }
}
