<?php

namespace CorporateTrainingBundle\Biz\ProjectPlan\Event;

use Codeages\Biz\Framework\Event\Event;
use Codeages\Biz\Framework\Event\EventSubscriber;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class MemberStatisticDataEventSubscriber extends EventSubscriber implements EventSubscriberInterface
{
    public static function getSubscribedEvents()
    {
        return array(
            'offline.exam.mark.pass' => 'onOfflineExamMarkPass',
            'offline.exam.mark.unpass' => 'onOfflineExamMarkUnPass',
        );
    }

    public function onOfflineExamMarkPass(Event $event)
    {
        $member = $event->getSubject();
        $offlineExam = $this->getOfflineExamService()->getOfflineExam($member['offlineExamId']);

        $member['exam'] = $offlineExam;
        $this->getNotificationService()->notify($member['userId'], 'offline_exam_mark', $member);
    }

    public function onOfflineExamMarkUnPass(Event $event)
    {
        $member = $event->getSubject();
        $offlineExam = $this->getOfflineExamService()->getOfflineExam($member['offlineExamId']);

        $member['exam'] = $offlineExam;
        $this->getNotificationService()->notify($member['userId'], 'offline_exam_mark', $member);
    }

    /**
     * @return \CorporateTrainingBundle\Biz\OfflineCourse\Service\Impl\TaskServiceImpl
     */
    protected function getOfflineCourseTaskService()
    {
        return $this->createService('CorporateTrainingBundle:OfflineCourse:TaskService');
    }

    /**
     * @return \CorporateTrainingBundle\Biz\OfflineCourse\Service\Impl\MemberServiceImpl
     */
    protected function getOfflineCourseMemberService()
    {
        return $this->createService('CorporateTrainingBundle:OfflineCourse:MemberService');
    }

    /**
     * @return \CorporateTrainingBundle\Biz\OfflineCourse\Service\Impl\OfflineCourseServiceImpl
     */
    protected function getOfflineCourseService()
    {
        return $this->createService('CorporateTrainingBundle:OfflineCourse:OfflineCourseService');
    }

    /**
     * @return \CorporateTrainingBundle\Biz\OfflineExam\Service\Impl\OfflineExamServiceImpl
     */
    protected function getOfflineExamService()
    {
        return $this->createService('CorporateTrainingBundle:OfflineExam:OfflineExamService');
    }

    protected function createService($alias)
    {
        return $this->getBiz()->service($alias);
    }

    /**
     * @return \Biz\User\Service\Impl\NotificationServiceImpl
     */
    protected function getNotificationService()
    {
        return $this->getBiz()->service('User:NotificationService');
    }
}
