<?php

namespace CorporateTrainingBundle\Biz\ProjectPlan\Event;

use AppBundle\Common\ArrayToolkit;
use Codeages\Biz\Framework\Event\Event;
use Codeages\Biz\Framework\Event\EventSubscriber;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class ProjectPlanEventSubscriber extends EventSubscriber implements EventSubscriberInterface
{
    public static function getSubscribedEvents()
    {
        return [
            'projectPlan.item.set' => 'onProjectPlanItemSet',
            'project_plan.update' => 'onProjectPlanUpdate',
            'projectPlan.item.delete' => 'onProjectPlanItemDelete',
        ];
    }

    public function onProjectPlanUpdate(Event $event)
    {
        $projectPlan = $event->getSubject();
        $oldProjectPlan = $event->getArgument('oldProjectPlan');
        if ($projectPlan['maxStudentNum'] != $oldProjectPlan['maxStudentNum'] && $projectPlan['maxStudentNum'] > $oldProjectPlan['maxStudentNum']) {
            $this->getEnrollStrategyContext()->createStrategy('projectPlan')->batchQueueListBecomeMember($projectPlan['id'], $projectPlan['maxStudentNum'] - $oldProjectPlan['maxStudentNum']);
        }
    }

    public function onProjectPlanItemSet(Event $event)
    {
        $projectPlanId = $event->getSubject();
        $params = $event->getArgument('params');
        $projectPlan = $this->getProjectPlanService()->getProjectPlan($projectPlanId);

        if (!empty($params['startTime'])) {
            $startTime = strtotime($params['startTime']);
            if (($projectPlan['startTime'] > 0 && $startTime < $projectPlan['startTime']) || $projectPlan['startTime'] <= 0) {
                $this->getProjectPlanService()->updateProjectPlan($projectPlan['id'], ['startTime' => $startTime]);
            }
        }

        if (!empty($params['endTime'])) {
            $endTime = strtotime($params['endTime']);
            if ($endTime > $projectPlan['endTime']) {
                $this->getProjectPlanService()->updateProjectPlan($projectPlan['id'], ['endTime' => $endTime]);
            }
        }
    }

    public function onProjectPlanItemDelete(Event $event)
    {
        $projectPlanId = $event->getSubject();
        $projectPlanItems = $this->getProjectPlanService()->searchProjectPlanItems(
            ['projectPlanId' => $projectPlanId],
            ['seq' => 'ASC'],
            0,
            PHP_INT_MAX
        );
        $projectPlanItemIds = ArrayToolkit::column($projectPlanItems, 'id');
        $this->getProjectPlanService()->sortItems($projectPlanItemIds);
    }

    /**
     * @return \CorporateTrainingBundle\Biz\ProjectPlan\Service\Impl\ProjectPlanServiceImpl
     */
    protected function getProjectPlanService()
    {
        return $this->getBiz()->service('CorporateTrainingBundle:ProjectPlan:ProjectPlanService');
    }

    protected function getEnrollStrategyContext()
    {
        return $this->getBiz()['enroll_strategy_context'];
    }
}
