<?php

namespace CorporateTrainingBundle\Biz\ProjectPlan\Event;

use AppBundle\Common\ArrayToolkit;
use Codeages\Biz\Framework\Event\EventSubscriber;
use Codeages\Biz\Framework\Event\Event;
use CorporateTrainingBundle\Biz\OfflineCourse\Service\OfflineCourseService;
use CorporateTrainingBundle\Biz\OfflineCourse\Service\OfflineCourseSurveyService;
use SurveyPlugin\Biz\Survey\Service\SurveyService;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class ProjectPlanItemEventSubscriber extends EventSubscriber implements EventSubscriberInterface
{
    public static function getSubscribedEvents()
    {
        return [
            'project_plan.create.questionnaire' => 'onProjectPlanCreateQuestionnaire',
            'project_plan.update.questionnaire' => 'onProjectPlanUpdateQuestionnaire',
        ];
    }

    public function onProjectPlanCreateQuestionnaire(Event $event)
    {
        $item = $event->getSubject();
        $offlineCourseIds = $event->getArgument('offlineCourseIds');
        if (empty($offlineCourseIds)) {
            return;
        }
        $biz = $this->getBiz();
        $user = $biz['user'];
        foreach ($offlineCourseIds as $offlineCourseId) {
            $this->createOfflineCourseSurvey($offlineCourseId, $item, $user['id']);
        }
    }

    public function onProjectPlanUpdateQuestionnaire(Event $event)
    {
        $item = $event->getSubject();
        $oldItem = $event->getArgument('oldItem');
        $offlineCourseIds = $event->getArgument('offlineCourseIds');
        $records = $this->getOfflineCourseSurveyService()->findOfflineCourseSurveysByTargetIdAndTargetType($item['id'], 'projectPlanItem');

        if ($oldItem['targetId'] != $item['targetId']) {
            return $this->updateProjectPlanItemQuestionnaireId($item, $records, $offlineCourseIds);
        }
        $this->createQuestionnaireItem($item, $records, $offlineCourseIds);
    }

    protected function updateProjectPlanItemQuestionnaireId($item, $records, $offlineCourseIds)
    {
        $biz = $this->getBiz();
        $user = $biz['user'];
        foreach ($records as $record) {
            $this->getSurveyService()->closeSurvey($record['surveyId']);
            $this->getSurveyService()->deleteSurvey($record['surveyId']);
        }
        $this->getOfflineCourseSurveyService()->deleteOfflineCourseSurveysByTargetIdAndTargetType($item['id'], 'projectPlanItem');
        foreach ($offlineCourseIds as $offlineCourseId) {
            $this->createOfflineCourseSurvey($offlineCourseId, $item, $user['id']);
        }

        return true;
    }

    protected function createQuestionnaireItem($item, $records, $offlineCourseIds)
    {
        $exitsOfflineCourseIds = ArrayToolkit::column($records, 'offlineCourseId');
        $records = ArrayToolkit::index($records, 'offlineCourseId');
        $intersectCourseIds = array_intersect($offlineCourseIds, $exitsOfflineCourseIds);
        if (count($offlineCourseIds) == count($exitsOfflineCourseIds) && count($intersectCourseIds) == count($offlineCourseIds)) {
            return;
        }
        $biz = $this->getBiz();
        $user = $biz['user'];
        $courseIds = array_merge($exitsOfflineCourseIds, $offlineCourseIds);
        $courseIds = array_unique($courseIds);
        $diffCourseIds = array_diff($exitsOfflineCourseIds, $offlineCourseIds);
        foreach ($courseIds as $offlineCourseId) {
            if (in_array($offlineCourseId, $intersectCourseIds)) {
                continue;
            }
            if (in_array($offlineCourseId, $diffCourseIds) && !empty($records[$offlineCourseId])) {
                $this->getOfflineCourseSurveyService()->deleteOfflineCourseSurvey($records[$offlineCourseId]['id']);
                continue;
            }
            $this->createOfflineCourseSurvey($offlineCourseId, $item, $user['id']);
        }
    }

    /**
     * @param $offlineCourseId
     * @param $item
     * @param $userId
     */
    protected function createOfflineCourseSurvey($offlineCourseId, $item, $userId)
    {
        $offlineCourse = $this->getOfflineCourseService()->getOfflineCourse($offlineCourseId);
        $survey = [
            'name' => $offlineCourse['title'],
            'type' => 'offlineCourseQuestionnaire',
            'status' => 'published',
            'questionnaireId' => $item['targetId'],
            'createdUserId' => $userId,
        ];
        $survey = $this->getSurveyDao()->create($survey);
        $questionnaireRecord = [
            'targetId' => $item['id'],
            'targetType' => 'projectPlanItem',
            'offlineCourseId' => $offlineCourseId,
            'surveyId' => $survey['id'],
        ];

        $this->getOfflineCourseSurveyService()->createOfflineCourseSurvey($questionnaireRecord);
    }

    protected function getSurveyDao()
    {
        return $this->getBiz()->dao('SurveyPlugin:Survey:SurveyDao');
    }

    /**
     * @return OfflineCourseService
     */
    protected function getOfflineCourseService()
    {
        return $this->getBiz()->service('CorporateTrainingBundle:OfflineCourse:OfflineCourseService');
    }

    /**
     * @return OfflineCourseSurveyService
     */
    protected function getOfflineCourseSurveyService()
    {
        return $this->getBiz()->service('CorporateTrainingBundle:OfflineCourse:OfflineCourseSurveyService');
    }

    /**
     * @return SurveyService
     */
    protected function getSurveyService()
    {
        return $this->getBiz()->service('SurveyPlugin:Survey:SurveyService');
    }
}
