<?php

namespace CorporateTrainingBundle\Biz\ProjectPlan\Strategy\Impl;

use AppBundle\Common\ArrayToolkit;
use CorporateTrainingBundle\Biz\ProjectPlan\Strategy\BaseProjectPlanItemStrategy;
use CorporateTrainingBundle\Biz\ProjectPlan\Strategy\ProjectPlanItemStrategy;
use SurveyPlugin\Biz\Survey\Service\SurveyResultService;

class OfflineCourseProjectPlanItemStrategyImpl extends BaseProjectPlanItemStrategy implements ProjectPlanItemStrategy
{
    public function createItems($projectPlanId, $items, $itemType = 'offline_course')
    {
        $this->checkProjectPlanExist($projectPlanId);

        $items = $this->buildItems($items);
        $items['targetId'] = $projectPlanId;

        $offlineCourse = $this->getOfflineCourseService()->createOfflineCourse($items);
        $this->getOfflineCourseService()->publishOfflineCourse($offlineCourse['id']);

        $itemsNum = $this->getProjectPlanService()->countProjectPlanItems(
            [
                'projectPlanId' => $projectPlanId,
            ]
        );

        $projectPlanItem = [
            'targetId' => $offlineCourse['id'],
            'targetType' => $itemType,
            'projectPlanId' => $projectPlanId,
            'seq' => $itemsNum + 1,
        ];

        $this->getProjectPlanService()->createProjectPlanItem($projectPlanItem);

        if (!empty($items['signTasks'])) {
            foreach ($items['signTasks'] as $key => $signTask) {
                $signTask = [
                    'title' => $offlineCourse['title'],
                    'offlineCourseId' => $offlineCourse['id'],
                    'startTime' => $signTask['signStartTime'],
                    'endTime' => $signTask['signEndTime'],
                    'mediaType' => 'offlineCourseSign',
                    'creator' => $offlineCourse['creator'],
                    'seq' => $key,
                    'type' => 'sign',
                ];
                $this->getOfflineCourseTaskService()->createTask($signTask);
            }
        }

        if (!empty($items['homeworkTasks'])) {
            foreach ($items['homeworkTasks'] as $key => $homeworkTask) {
                $signTask = [
                    'title' => $offlineCourse['title'],
                    'offlineCourseId' => $offlineCourse['id'],
                    'mediaType' => 'offlineCourseHomework',
                    'creator' => $offlineCourse['creator'],
                    'seq' => $key,
                    'type' => 'homework',
                    'endTime' => $homeworkTask['homeworkDeadline'],
                    'homeworkDeadline' => $homeworkTask['homeworkDeadline'],
                    'homeworkDemand' => $homeworkTask['homeworkDemand'],
                ];
                $this->getOfflineCourseTaskService()->createTask($signTask);
            }
        }
    }

    public function updateItem($id, $item, $itemType = null)
    {
        $fields = $this->getProjectPlanService()->getProjectPlanItem($id);
        $item = $this->buildItems($item);
        $offlineCourse = $this->getOfflineCourseService()->getOfflineCourse($fields['targetId']);

        $this->getOfflineCourseService()->updateOfflineCourse($offlineCourse['id'], $item);
        $this->getProjectPlanService()->updateProjectPlanItem($id, ['startTime' => $item['startTime'], 'endTime' => $item['endTime']]);
        $tasks = $this->getOfflineCourseTaskService()->findTasksByOfflineCourseId($offlineCourse['id']);
        foreach ($tasks as $task) {
            $this->getOfflineCourseTaskService()->deleteTask($task['id']);
        }

        if (!empty($item['signTasks'])) {
            foreach ($item['signTasks'] as $key => $signTask) {
                $signTask = [
                    'title' => $offlineCourse['title'],
                    'offlineCourseId' => $offlineCourse['id'],
                    'startTime' => $signTask['signStartTime'],
                    'endTime' => $signTask['signEndTime'],
                    'mediaType' => 'offlineCourseSign',
                    'creator' => $offlineCourse['creator'],
                    'seq' => $key,
                    'type' => 'sign',
                ];
                $this->getOfflineCourseTaskService()->createTask($signTask);
            }
        }

        if (!empty($item['homeworkTasks'])) {
            foreach ($item['homeworkTasks'] as $key => $homeworkTask) {
                $signTask = [
                    'title' => $offlineCourse['title'],
                    'offlineCourseId' => $offlineCourse['id'],
                    'mediaType' => 'offlineCourseHomework',
                    'creator' => $offlineCourse['creator'],
                    'seq' => $key,
                    'type' => 'homework',
                    'endTime' => $homeworkTask['homeworkDeadline'],
                    'homeworkDeadline' => $homeworkTask['homeworkDeadline'],
                    'homeworkDemand' => $homeworkTask['homeworkDemand'],
                ];
                $this->getOfflineCourseTaskService()->createTask($signTask);
            }
        }
    }

    public function deleteItem($item)
    {
        $this->getOfflineCourseService()->closeOfflineCourse($item['targetId']);
    }

    public function getItem($item)
    {
        $offlineCourse = $this->getOfflineCourseService()->getOfflineCourse($item['targetId']);
        $item['detail'] = $offlineCourse;
        $offlineCourseTasks = $this->getOfflineCourseTaskService()->findTasksByOfflineCourseId($offlineCourse['id']);
        $item['tasks'] = $offlineCourseTasks;

        return $item;
    }

    public function getTaskReviewNum($taskId)
    {
        $reviewNum = $this->getOfflineCourseTaskService()->countTaskResults(['status' => 'submitted', 'taskId' => $taskId]);

        return $reviewNum;
    }

    public function getStudyResult($item, $user)
    {
        return [];
    }

    public function getItemInfoByUserId($item, $userId)
    {
        $offlineCourseTasks = $this->getOfflineCourseService()->findOfflineCourseItems($item['targetId']);

        foreach ($offlineCourseTasks as $offlineCourseTask) {
            if ('sign' == $offlineCourseTask['type']) {
                $offlineCourseTaskInfo[] = [
                    'taskId' => $offlineCourseTask['id'],
                    'mediaId' => isset($offlineCourseTask['activity']['mediaId']) ? $offlineCourseTask['activity']['mediaId'] : 0,
                    'mediaType' => isset($offlineCourseTask['activity']['mediaType']) ? $offlineCourseTask['activity']['mediaType'] : 'offlineCourseSign',
                    'title' => '第'.$offlineCourseTask['seq'].'次签到',
                    'startTime' => $offlineCourseTask['startTime'],
                    'endTime' => $offlineCourseTask['endTime'],
                    'attendStatus' => $this->getAttendStatus($offlineCourseTask['id'], $userId),
                ];
            }
        }

        return isset($offlineCourseTaskInfo) ? $offlineCourseTaskInfo : [];
    }

    public function findItemsDetail($items)
    {
        $offlineCourseIds = ArrayToolkit::column($items, 'targetId');

        $offlineCourses = $this->getOfflineCourseService()->findOfflineCoursesByIds($offlineCourseIds);
        $offlineCourses = ArrayToolkit::index($offlineCourses, 'id');

        foreach ($items as &$item) {
            if (isset($offlineCourses[$item['targetId']])) {
                $item['detail'] = $offlineCourses[$item['targetId']];
            }
        }

        return ArrayToolkit::index($items, 'id');
    }

    public function findTasksByItemIdAndTimeRange($offlineCourseId, $timeRange)
    {
        $tasks = $this->getOfflineCourseTaskService()->findTasksByOfflineCourseIdAndTimeRange($offlineCourseId, $timeRange);

        return $tasks;
    }

    public function isFinished($item, $user)
    {
        $result = false;
        $offlineCourse = $this->getOfflineCourseService()->getOfflineCourse($item['targetId']);
        $offlineCourseMembers = $this->getOfflineCourseMemberService()->searchMembers(
            ['offlineCourseId' => $offlineCourse['id'], 'userId' => $user['id'], 'learnedNumGreaterThan' => $offlineCourse['taskNum']],
            ['id' => 'ASC'],
            0,
            PHP_INT_MAX
        );

        if (empty($offlineCourseMembers)) {
            return $result;
        }

        $memberNum = $this->getProjectPlanMemberService()->countProjectPlanMembers(['userIds' => ArrayToolkit::column($offlineCourseMembers, 'userId'), 'projectPlanId' => $item['projectPlanId']]);

        if (1 == $memberNum) {
            return true;
        }

        return $result;
    }

    public function findFinishedMembers($item)
    {
        $offlineCourse = $this->getOfflineCourseService()->getOfflineCourse($item['targetId']);
        $offlineCourseMembers = $this->getOfflineCourseMemberService()->searchMembers(
            ['offlineCourseId' => $offlineCourse['id'], 'learnedNumGreaterThan' => $offlineCourse['taskNum']],
            ['id' => 'ASC'],
            0,
            PHP_INT_MAX
        );

        if (empty($offlineCourseMembers)) {
            return [];
        }

        return $this->getProjectPlanMemberService()->searchProjectPlanMembers(
            ['userIds' => ArrayToolkit::column($offlineCourseMembers, 'userId'), 'projectPlanId' => $item['projectPlanId']],
            ['id' => 'ASC'],
            0,
            PHP_INT_MAX
        );
    }

    public function getFinishedMembersNum($item)
    {
        $offlineCourse = $this->getOfflineCourseService()->getOfflineCourse($item['targetId']);
        $offlineCourseMembers = $this->getOfflineCourseMemberService()->searchMembers(
            ['offlineCourseId' => $offlineCourse['id'], 'learnedNumGreaterThan' => $offlineCourse['taskNum']],
            ['id' => 'ASC'],
            0,
            PHP_INT_MAX
        );

        if (empty($offlineCourseMembers)) {
            return 0;
        }

        return $this->getProjectPlanMemberService()->countProjectPlanMembers(['userIds' => ArrayToolkit::column($offlineCourseMembers, 'userId'), 'projectPlanId' => $item['projectPlanId']]);
    }

    protected function getQuestionnaireStatus($surveyId, $userId)
    {
        $result = $this->getSurveyResultService()->getSurveyResultByUserIdAndSurveyIdAndStatus($userId, $surveyId, 'finished');

        if ($result) {
            return $result['status'];
        }

        return 'notStart';
    }

    protected function buildItems($params)
    {
        if (!empty($params['startTime'])) {
            $params['startTime'] = strtotime($params['startTime']);
        }

        if (!empty($params['endTime'])) {
            $params['endTime'] = strtotime($params['endTime']);
        }

        if (!empty($params['signStartTime']) && !empty($params['signEndTime'])) {
            $params['signTasks'] = [];
            foreach ($params['signStartTime'] as $key => $signStartTime) {
                $params['signTasks'][$key]['signStartTime'] = strtotime($signStartTime);
                if (!empty($params['signEndTime'][$key])) {
                    $params['signTasks'][$key]['signEndTime'] = strtotime($params['signEndTime'][$key]);
                } else {
                    unset($params['signTasks'][$key]['signStartTime']);
                }
            }
        }

        if (!empty($params['homeworkDemand']) && !empty($params['homeworkDeadline'])) {
            $params['homeworkTasks'] = [];
            foreach ($params['homeworkDemand'] as $key => $homeworkDemand) {
                $params['homeworkTasks'][$key]['homeworkDemand'] = $homeworkDemand;
                if (!empty($params['homeworkDeadline'][$key])) {
                    $params['homeworkTasks'][$key]['homeworkDeadline'] = strtotime($params['homeworkDeadline'][$key]);
                } else {
                    unset($params['homeworkTasks'][$key]['homeworkDemand']);
                }
            }
        }
        $params['targetType'] = 'projectPlan';

        return $params;
    }

    protected function getAttendStatus($offlineCourseTaskId, $userId)
    {
        $offlineCourseTaskResult = $this->getOfflineCourseTaskService()->getTaskResultByTaskIdAndUserId($offlineCourseTaskId, $userId);

        return !empty($offlineCourseTaskResult) ? 'attended' : 'unattended';
    }

    /**
     * @return \CorporateTrainingBundle\Biz\OfflineCourse\Service\Impl\TaskServiceImpl
     */
    protected function getOfflineCourseTaskService()
    {
        return $this->createService('CorporateTrainingBundle:OfflineCourse:TaskService');
    }

    /**
     * @return \CorporateTrainingBundle\Biz\OfflineCourse\Service\Impl\OfflineCourseServiceImpl
     */
    protected function getOfflineCourseService()
    {
        return $this->createService('CorporateTrainingBundle:OfflineCourse:OfflineCourseService');
    }

    /**
     * @return \CorporateTrainingBundle\Biz\OfflineCourse\Service\Impl\MemberServiceImpl
     */
    protected function getOfflineCourseMemberService()
    {
        return $this->createService('CorporateTrainingBundle:OfflineCourse:MemberService');
    }

    protected function getOfflineCourseAttendanceService()
    {
        return $this->createService('CorporateTrainingBundle:OfflineCourse:MemberService');
    }

    protected function getOfflineCourseActivityService()
    {
        return $this->createService('CorporateTrainingBundle:Activity:OfflineCourseActivityService');
    }

    protected function getActivityService()
    {
        return $this->createService('Activity:ActivityService');
    }

    /**
     * @return SurveyResultService
     */
    protected function getSurveyResultService()
    {
        return $this->createService('SurveyPlugin:Survey:SurveyResultService');
    }
}
