<?php

namespace CorporateTrainingBundle\Biz\ProjectPlan\Strategy\Impl;

use AppBundle\Common\ArrayToolkit;
use AppBundle\Common\Exception\AccessDeniedException;
use Codeages\Biz\Framework\Event\Event;
use CorporateTrainingBundle\Biz\OfflineCourse\Service\OfflineCourseSurveyService;
use CorporateTrainingBundle\Biz\ProjectPlan\Strategy\ProjectPlanItemStrategy;
use CorporateTrainingBundle\Biz\ProjectPlan\Strategy\BaseProjectPlanItemStrategy;
use SurveyPlugin\Biz\Survey\Service\SurveyResultService;
use Topxia\Service\Common\ServiceKernel;

class QuestionnaireProjectPlanItemStrategyImpl extends BaseProjectPlanItemStrategy implements ProjectPlanItemStrategy
{
    public function createItems($projectPlanId, $items, $itemType = 'questionnaire')
    {
        $this->checkProjectPlanExist($projectPlanId);

        $items['projectPlanId'] = $projectPlanId;
        $itemsNum = $this->getProjectPlanService()->countProjectPlanItems(
            [
                'projectPlanId' => $projectPlanId,
            ]
        );
        if (!empty($items['startTime'])) {
            $items['startTime'] = strtotime($items['startTime']);
        }
        $projectPlanItem = [
            'targetId' => $items['questionnaireId'],
            'targetType' => $itemType,
            'projectPlanId' => $projectPlanId,
            'seq' => $itemsNum + 1,
            'startTime' => $items['startTime'],
            'endTime' => 0,
        ];
        $questionnaire = $this->getQuestionnaireService()->getQuestionnaire($items['questionnaireId']);
        $hasPermission = $this->getManagePermissionService()->checkResourceUsePermission('pluginQuestionnaire', $items['questionnaireId'], $questionnaire['orgId']);
        if (!$hasPermission) {
            throw new AccessDeniedException('questionnaire Not Use Permission');
        }
        $item = $this->getProjectPlanService()->createProjectPlanItem($projectPlanItem);
        $items['offlineCourseIds'] = explode(',', $items['offlineCourseIds']);
        $this->dispatchEvent('project_plan.create.questionnaire', new Event($item, ['offlineCourseIds' => $items['offlineCourseIds'], 'type' => 'projectPlan']));
    }

    public function updateItem($id, $item, $itemType = null)
    {
        $oldItem = $this->getProjectPlanService()->getProjectPlanItem($id);
        if (!empty($item['startTime'])) {
            $item['startTime'] = strtotime($item['startTime']);
        }
        $projectPlanItem = [
            'targetId' => $item['questionnaireId'],
            'startTime' => $item['startTime'],
            'endTime' => 0,
        ];

        $newItem = $this->getProjectPlanService()->updateProjectPlanItem($id, $projectPlanItem);

        $this->dispatchEvent('project_plan.update.questionnaire', new Event($newItem, ['oldItem' => $oldItem, 'offlineCourseIds' => explode(',', $item['offlineCourseIds']), 'type' => 'projectPlan']));
    }

    public function deleteItem($item)
    {
        $this->getOfflineCourseSurveyService()->deleteOfflineCourseSurveysByTargetIdAndTargetType($item['id'], 'projectPlanItem');
        $this->dispatchEvent('project_plan.delete.questionnaire', new Event($item, ['type' => 'projectPlan']));
    }

    public function getItem($item)
    {
        $item['detail'] = ['name' => $this->trans('project_plan.questionnaire')];

        return $item;
    }

    public function getTaskReviewNum($taskId)
    {
        return null;
    }

    public function getItemInfoByUserId($item, $user)
    {
        return [];
    }

    public function getStudyResult($item, $userId)
    {
        return [];
    }

    public function findItemsDetail($items)
    {
        foreach ($items as &$item) {
            $item['detail'] = ['name' => $this->trans('project_plan.questionnaire')];
        }

        return ArrayToolkit::index($items, 'id');
    }

    public function findTasksByItemIdAndTimeRange($itemId, $timeRange)
    {
        return [];
    }

    public function isFinished($item, $user)
    {
        $questionnaireRecords = $this->getOfflineCourseSurveyService()->findOfflineCourseSurveysByTargetIdAndTargetType($item['id'], 'projectPlanItem');
        $surveyIds = ArrayToolkit::column($questionnaireRecords, 'surveyId');
        $surveyResults = $this->getSurveyResultService()->searchSurveyResults(['userId' => $user['id'], 'surveyIds' => empty($surveyIds) ? [-1] : $surveyIds, 'status' => 'finished'], [], 0, 1);

        if (empty($surveyResults)) {
            return false;
        }

        return true;
    }

    public function findFinishedMembers($item)
    {
        $questionnaireRecords = $this->getOfflineCourseSurveyService()->findOfflineCourseSurveysByTargetIdAndTargetType($item['id'], 'projectPlanItem');
        $surveyIds = ArrayToolkit::column($questionnaireRecords, 'surveyId');
        $surveyResults = $this->getSurveyResultService()->searchSurveyResults(['surveyIds' => empty($surveyIds) ? [-1] : [$surveyIds[0]], 'status' => 'finished'], [], 0, PHP_INT_MAX);
        $userIds = ArrayToolkit::column($surveyResults, 'userId');

        return $this->getProjectPlanMemberService()->searchProjectPlanMembers(
            ['userIds' => empty($userIds) ? [-1] : $userIds, 'projectPlanId' => $item['projectPlanId']],
            ['id' => 'ASC'],
            0,
            PHP_INT_MAX
        );
    }

    public function getFinishedMembersNum($item)
    {
        $questionnaireRecords = $this->getOfflineCourseSurveyService()->findOfflineCourseSurveysByTargetIdAndTargetType($item['id'], 'projectPlanItem');
        $surveyIds = ArrayToolkit::column($questionnaireRecords, 'surveyId');

        return $this->getSurveyResultService()->countSurveyResults(['surveyIds' => empty($surveyIds) ? [-1] : [$surveyIds[0]], 'status' => 'finished']);
    }

    /**
     * @return \CorporateTrainingBundle\Biz\OfflineExam\Service\Impl\OfflineExamServiceImpl
     */
    protected function getOfflineExamService()
    {
        return $this->createService('CorporateTrainingBundle:OfflineExam:OfflineExamService');
    }

    /**
     * @return \CorporateTrainingBundle\Biz\OfflineExam\Service\Impl\MemberServiceImpl
     */
    protected function getOfflineExamMemberService()
    {
        return $this->createService('CorporateTrainingBundle:OfflineExam:MemberService');
    }

    protected function getQuestionnaireService()
    {
        return $this->createService('SurveyPlugin:Questionnaire:QuestionnaireService');
    }

    /**
     * @return OfflineCourseSurveyService
     */
    protected function getOfflineCourseSurveyService()
    {
        return $this->createService('CorporateTrainingBundle:OfflineCourse:OfflineCourseSurveyService');
    }

    protected function trans($message, $arguments = [], $domain = null, $locale = null)
    {
        return ServiceKernel::instance()->trans($message, $arguments, $domain, $locale);
    }

    /**
     * @return SurveyResultService
     */
    protected function getSurveyResultService()
    {
        return $this->createService('SurveyPlugin:Survey:SurveyResultService');
    }
}
