<?php

namespace CorporateTrainingBundle\Biz\ResourceFavorite\Dao\Impl;

use Codeages\Biz\Framework\Dao\AdvancedDaoImpl;
use CorporateTrainingBundle\Biz\ResourceFavorite\Dao\ResourceFavoriteDao;

class ResourceFavoriteDaoImpl extends AdvancedDaoImpl implements ResourceFavoriteDao
{
    protected $table = 'resource_favorite';

    public function deleteByTargetTypeAndTargetIdAndUserId($targetType, $targetId, $userId)
    {
        return $this->db()->delete($this->table, array('targetId' => $targetId, 'targetType' => $targetType, 'userId' => $userId));
    }

    public function getByUserIdAndTargetTypeAndTargetId($userId, $targetType, $targetId)
    {
        return $this->getByFields(array('userId' => $userId, 'targetType' => $targetType, 'targetId' => $targetId));
    }

    public function declares()
    {
        return array(
            'timestamps' => array('createdTime'),
            'orderbys' => array('createdTime', 'id'),
            'conditions' => array(
                'targetId = :targetId',
                'userId = :userId',
                'targetType = :targetType',
                'createdTime >= :createdTime_GE',
                'targetId IN ( :targetIds )',
                'targetId NOT IN ( :excludeTargetIds )',
            ),
        );
    }
}
