<?php

namespace CorporateTrainingBundle\Biz\ResourceFavorite\Service\Impl;

use Biz\BaseService;
use AppBundle\Common\ArrayToolkit;
use CorporateTrainingBundle\Biz\ResourceFavorite\Dao\ResourceFavoriteDao;
use CorporateTrainingBundle\Biz\ResourceFavorite\Service\ResourceFavoriteService;

class ResourceFavoriteServiceImpl extends BaseService implements ResourceFavoriteService
{
    public function createResourceFavorite($fields)
    {
        $favorite = $this->getResourceFavoriteByUserIdAndTargetTypeAndTargetId($fields['userId'], $fields['targetType'], $fields['targetId']);
        if (!empty($favorite)) {
            return  $favorite;
        }

        return $this->getResourceFavoriteDao()->create($this->filterFavoriteFields($fields));
    }

    public function updateResourceFavorite($id, $fields)
    {
        return $this->getResourceFavoriteDao()->update($id, $this->filterFavoriteFields($fields));
    }

    public function getResourceFavorite($id)
    {
        return $this->getResourceFavoriteDao()->get($id);
    }

    public function getResourceFavoriteByUserIdAndTargetTypeAndTargetId($userId, $targetType, $targetId)
    {
        return $this->getResourceFavoriteDao()->getByUserIdAndTargetTypeAndTargetId($userId, $targetType, $targetId);
    }

    public function deleteResourceFavorite($id)
    {
        return $this->getResourceFavoriteDao()->delete($id);
    }

    public function deleteResourceFavoriteByTargetTypeAndTargetIdAndUserId($targetType, $targetId, $userId)
    {
        return $this->getResourceFavoriteDao()->deleteByTargetTypeAndTargetIdAndUserId($targetType, $targetId, $userId);
    }

    public function countResourceFavorites($conditions)
    {
        return $this->getResourceFavoriteDao()->count($conditions);
    }

    public function searchResourceFavorites($conditions, $orderBys, $start, $limit, $columns = array())
    {
        return $this->getResourceFavoriteDao()->search($conditions, $orderBys, $start, $limit, $columns);
    }

    protected function filterFavoriteFields($fields)
    {
        return ArrayToolkit::parts(
            $fields,
            array(
                'targetId',
                'targetType',
                'userId',
            )
        );
    }

    /**
     * @return ResourceFavoriteDao
     */
    protected function getResourceFavoriteDao()
    {
        return $this->createDao('CorporateTrainingBundle:ResourceFavorite:ResourceFavoriteDao');
    }
}
