<?php

namespace CorporateTrainingBundle\Biz\ResourceScope\Service\Impl;

use Biz\BaseService;
use CorporateTrainingBundle\Biz\ResourceScope\Service\ResourceAccessScopeService;

class ResourceAccessScopeServiceImpl extends BaseService implements ResourceAccessScopeService
{
    public function canUserAccessResource($resourceType, $resourceId, $userId)
    {
        if (!$this->getResourceVisibleScopeService()->canUserVisitResource($resourceType, $resourceId, $userId)) {
            return false;
        }

        return $this->canUserAccessResourceWithoutVisibleScope($resourceType, $resourceId, $userId);
    }

    public function canUserAccessResourceWithoutVisibleScope($resourceType, $resourceId, $userId)
    {
        $accessScopeTypes = $this->getStrategyContext()->getAccessScopeTypes();
        foreach ($accessScopeTypes as $accessScopeType) {
            $strategy = $this->getStrategyContext()->createStrategy($accessScopeType);
            $canAccess = $strategy->canAccess($resourceType, $resourceId, $userId);
            if (!$canAccess) {
                return false;
            }
        }

        return true;
    }

    public function setResourceAccessScope($resourceId, $resourceType, $data)
    {
        $accessScopeTypes = $this->getStrategyContext()->getAccessScopeTypes();
        try {
            $this->beginTransaction();
            foreach ($accessScopeTypes as $accessScopeType) {
                $accessScopeTypeData = '';
                $strategy = $this->getStrategyContext()->createStrategy($accessScopeType);
                if ($data['conditionalAccess']) {
                    $accessScopeTypeData = $data['access'.$accessScopeType];
                }
                $strategy->setResourceAccessScope($resourceType, $resourceId, $accessScopeTypeData);
            }
            $this->commit();
        } catch (\Exception $e) {
            $this->getLogger()->error('setResourceAccessScope:'.$e->getMessage());
            $this->rollback();
            throw $e;
        }
    }

    public function processAccessScope($fields)
    {
        switch ($fields['hireDateType']) {
            case 'greatThanOrEqual':
                $fields['accessHireDate'] = ['hireDateType' => 'greatThanOrEqual', 'days' => isset($fields['days']) ? (int) $fields['days'] : ''];
                break;
            case 'lessThanOrEqual':
                $fields['accessHireDate'] = ['hireDateType' => 'lessThanOrEqual', 'days' => isset($fields['days']) ? (int) $fields['days'] : ''];
                break;
            case 'between':
                $fields['accessHireDate'] = ['hireDateType' => 'between', 'hireStartDate' => isset($fields['hireStartDate']) ? $fields['hireStartDate'] : '', 'hireEndDate' => isset($fields['hireEndDate']) ? $fields['hireEndDate'] : ''];
                break;
            case 'before':
                $fields['accessHireDate'] = ['hireDateType' => 'before', 'date' => isset($fields['date']) ? $fields['date'] : ''];
                break;
            case 'after':
                $fields['accessHireDate'] = ['hireDateType' => 'after', 'date' => isset($fields['date']) ? $fields['date'] : ''];
                break;
            default:
                $fields['accessHireDate'] = [];
                break;
        }

        if (count(array_filter($fields['accessHireDate'])) < 2) {
            $fields['accessHireDate'] = [];
        }
        if (!isset($fields['accessUserGroup']) && !isset($fields['accessPost']) && !isset($fields['accessOrg']) && !isset($fields['publishPostRank']) && isset($fields['accessHireDate'])) {
            $fields['conditionalAccess'] = 0;
            unset($fields['accessUserGroup'], $fields['accessPost'], $fields['accessOrg'], $fields['publishPostRank'], $fields['hireDateType']);
        }

        return $fields;
    }

    protected function getStrategyContext()
    {
        return $this->biz['resource_scope_strategy_context'];
    }

    protected function getUserService()
    {
        return $this->createService('User:UserService');
    }

    /**
     * @return ResourceVisibleScopeServiceImpl
     */
    protected function getResourceVisibleScopeService()
    {
        return $this->createService('ResourceScope:ResourceVisibleScopeService');
    }
}
