<?php

namespace CorporateTrainingBundle\Biz\Taxonomy\Dao\Impl;

use Biz\Taxonomy\Dao\Impl\CategoryDaoImpl as BaseCategoryDao;

class CategoryDaoImpl extends BaseCategoryDao
{
    public function initOrgsRelation()
    {
        $sql = "UPDATE {$this->table} SET orgId = ?, orgCode = ?";

        return $this->db()->executeUpdate($sql, ['1', '1.']);
    }

    public function findByGroupIdAndNames($groupId, $names)
    {
        $marks = str_repeat('?,', count($names) - 1).'?';
        $sql = "SELECT * FROM {$this->table()} WHERE groupId = ? AND name IN ({$marks})";

        return $this->db()->fetchAll($sql, array_merge([$groupId], $names));
    }

    public function declares()
    {
        return [
            'orderbys' => ['id', 'createdTime', 'updatedTime', 'weight'],
            'conditions' => [
                'id = :id',
                'name LIKE :name',
                'groupId = :groupId',
                'parentId IN ( :parentIds )',
            ],
        ];
    }
}
