<?php

namespace CorporateTrainingBundle\Biz\User\Dao\Impl;

use Codeages\Biz\Framework\Dao\AdvancedDaoImpl;
use CorporateTrainingBundle\Biz\User\Dao\UserOrgDao;

class UserOrgDaoImpl extends AdvancedDaoImpl implements UserOrgDao
{
    protected $table = 'user_org';

    public function findByUserId($userId)
    {
        return $this->findByFields(array('userId' => $userId));
    }

    public function findByOrgIds(array $orgIds)
    {
        return $this->findInField('orgId', $orgIds);
    }

    public function updateOrgbyPrefixOrgCode($orgCode, $orgProperty)
    {
        $likeOrgCode = $orgCode.'%';
        $sql = "UPDATE  {$this->table()} set org where orgCode like ? ";
    }

    public function initOrgsRelation()
    {
        $sql = "UPDATE {$this->table} SET orgId = ?, orgCode = ?";

        return $this->db()->executeUpdate($sql, ['1', '1.']);
    }

    public function declares()
    {
        return array(
            'orderbys' => array(
              'id',
              'createdTime',
              'updatedTime',
            ),
            'timestamps' => array(
                'createdTime',
                'updatedTime',
            ),
            'conditions' => array(
                'id = :id',
                'id IN ( :ids)',
                'orgId = :orgId',
                'orgId In ( :orgIds)',
                'orgCode = :orgCode',
                'userId = :userId',
                'userId IN ( :userIds)',
                'orgCode PRE_LIKE :likeOrgCode',
            ),
        );
    }
}
